/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.generics.io;

import de.huxhorn.sulky.generics.io.Deserializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDeserializer<E extends Serializable>
implements Deserializer<E> {
    boolean compressing;

    public SerializableDeserializer() {
        this(false);
    }

    public SerializableDeserializer(boolean compressing) {
        this.setCompressing(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public E deserialize(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        if (this.compressing) {
            GZIPInputStream gis = new GZIPInputStream(bis);
            ois = new ObjectInputStream(gis);
        } else {
            ois = new ObjectInputStream(bis);
        }
        Object result = ois.readObject();
        Serializable serializable = (Serializable)result;
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)bis);
        return (E)serializable;
        {
            catch (ClassCastException ex) {
                E e;
                try {
                    ex.printStackTrace();
                    e = null;
                }
                catch (Throwable e2) {
                    E e3;
                    try {
                        e2.printStackTrace();
                        e3 = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(ois);
                        IOUtils.closeQuietly((InputStream)bis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)ois);
                    IOUtils.closeQuietly((InputStream)bis);
                    return e3;
                }
                IOUtils.closeQuietly((InputStream)ois);
                IOUtils.closeQuietly((InputStream)bis);
                return e;
            }
        }
    }
}

