/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEvent
implements Serializable {
    private static final long serialVersionUID = -2716224578048229667L;
    private String logger;
    private Level level;
    private String threadName;
    private Date timeStamp;
    private String messagePattern;
    private String[] arguments;
    private ThrowableInfo throwable;
    private Map<String, String> mdc;
    private Marker marker;
    private ExtendedStackTraceElement[] callStack;
    private String applicationIdentifier;
    private transient String formattedMessage;

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
        this.formattedMessage = null;
    }

    public String getMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = MessageFormatter.format(this.messagePattern, this.arguments);
        }
        return this.formattedMessage;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
        this.formattedMessage = null;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ThrowableInfo getThrowable() {
        return this.throwable;
    }

    public void setThrowable(ThrowableInfo throwable) {
        this.throwable = throwable;
    }

    public Map<String, String> getMdc() {
        return this.mdc;
    }

    public void setMdc(Map<String, String> mdc) {
        this.mdc = mdc;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public ExtendedStackTraceElement[] getCallStack() {
        return this.callStack;
    }

    public void setCallStack(ExtendedStackTraceElement[] callStack) {
        this.callStack = callStack;
    }

    public String getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public void setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingEvent event = (LoggingEvent)o;
        if (this.applicationIdentifier != null ? !this.applicationIdentifier.equals(event.applicationIdentifier) : event.applicationIdentifier != null) {
            return false;
        }
        if (!Arrays.equals(this.arguments, event.arguments)) {
            return false;
        }
        if (!Arrays.equals(this.callStack, event.callStack)) {
            return false;
        }
        if (this.level != event.level) {
            return false;
        }
        if (this.logger != null ? !this.logger.equals(event.logger) : event.logger != null) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals(event.marker) : event.marker != null) {
            return false;
        }
        if (this.mdc != null ? !((Object)this.mdc).equals(event.mdc) : event.mdc != null) {
            return false;
        }
        if (this.messagePattern != null ? !this.messagePattern.equals(event.messagePattern) : event.messagePattern != null) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(event.threadName) : event.threadName != null) {
            return false;
        }
        if (this.throwable != null ? !this.throwable.equals(event.throwable) : event.throwable != null) {
            return false;
        }
        return !(this.timeStamp != null ? !this.timeStamp.equals(event.timeStamp) : event.timeStamp != null);
    }

    public int hashCode() {
        int result = this.logger != null ? this.logger.hashCode() : 0;
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.threadName != null ? this.threadName.hashCode() : 0);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this.messagePattern != null ? this.messagePattern.hashCode() : 0);
        result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
        result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        result = 31 * result + (this.mdc != null ? ((Object)this.mdc).hashCode() : 0);
        result = 31 * result + (this.marker != null ? this.marker.hashCode() : 0);
        result = 31 * result + (this.callStack != null ? Arrays.hashCode(this.callStack) : 0);
        result = 31 * result + (this.applicationIdentifier != null ? this.applicationIdentifier.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("LoggingEvent[");
        result.append("logger=").append(this.logger).append(", ");
        result.append("level=").append((Object)this.level).append(", ");
        result.append("messagePattern=").append(this.messagePattern).append(", ");
        result.append("threadName=").append(this.threadName).append(", ");
        result.append("applicationIdentifier=").append(this.applicationIdentifier).append(", ");
        result.append("timeStamp=").append(this.timeStamp);
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

