/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.io.Serializable;

public class ExtendedStackTraceElement
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4907919529165316605L;
    public static final int NATIVE_METHOD = -2;
    private String className;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private String codeLocation;
    private String version;
    private boolean exact;

    public ExtendedStackTraceElement() {
        this.lineNumber = -1;
    }

    public ExtendedStackTraceElement(StackTraceElement ste) {
        this(ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber());
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber) {
        this(className, methodName, fileName, lineNumber, null, null, false);
    }

    public ExtendedStackTraceElement(String className, String methodName, String fileName, int lineNumber, String codeLocation, String version, boolean exact) {
        this.className = className;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.codeLocation = codeLocation;
        this.version = version;
        this.exact = exact;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public void setCodeLocation(String codeLocation) {
        this.codeLocation = codeLocation;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isExact() {
        return this.exact;
    }

    public void setExact(boolean exact) {
        this.exact = exact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedStackTraceElement that = (ExtendedStackTraceElement)o;
        if (this.exact != that.exact) {
            return false;
        }
        if (this.lineNumber != that.lineNumber) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.codeLocation != null ? !this.codeLocation.equals(that.codeLocation) : that.codeLocation != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(that.fileName) : that.fileName != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.codeLocation != null ? this.codeLocation.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.exact ? 1 : 0);
        return result;
    }

    public StackTraceElement getStackTraceElement() {
        return new StackTraceElement(this.className, this.methodName, this.fileName, this.lineNumber);
    }

    public ExtendedStackTraceElement clone() throws CloneNotSupportedException {
        return (ExtendedStackTraceElement)super.clone();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        StringBuilder result = new StringBuilder();
        result.append(this.className).append(".").append(this.methodName);
        if (this.isNativeMethod()) {
            result.append("(Native Method)");
        }
        if (this.fileName != null) {
            result.append("(").append(this.fileName);
            if (this.lineNumber >= 0) {
                result.append(":").append(this.lineNumber);
            }
            result.append(")");
        } else {
            result.append("(Unknown Source)");
        }
        if (extended && (this.codeLocation != null || this.version != null)) {
            if (this.exact) {
                result.append(" [");
            } else {
                result.append(" ~[");
            }
            if (this.codeLocation != null) {
                result.append(this.codeLocation);
            }
            result.append(":");
            if (this.version != null) {
                result.append(this.version);
            }
            result.append("]");
        }
        return result.toString();
    }
}

