/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.buffers.SerializingFileBuffer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBufferFactory<T extends Serializable> {
    private final Logger logger = LoggerFactory.getLogger(FileBufferFactory.class);
    private LogFileFactory logFileFactory;

    public FileBufferFactory(LogFileFactory logFileFactory) {
        this.logFileFactory = logFileFactory;
    }

    public LogFileFactory getLogFileFactory() {
        return this.logFileFactory;
    }

    public FileBuffer<EventWrapper<T>> createBuffer(SourceIdentifier si) {
        File dataFile = this.logFileFactory.getDataFile(si);
        File indexFile = this.logFileFactory.getIndexFile(si);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Creating buffer for dataFile '{}'.", (Object)dataFile.getAbsolutePath());
        }
        return new SerializingFileBuffer(dataFile, indexFile);
    }

    public FileBuffer<EventWrapper<T>> createActiveBuffer(SourceIdentifier si) {
        FileBuffer<EventWrapper<T>> result;
        block2: {
            result = this.createBuffer(si);
            File activeFile = this.logFileFactory.getActiveFile(si);
            try {
                activeFile.createNewFile();
                activeFile.deleteOnExit();
            }
            catch (IOException e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Couldn't create active-file.");
            }
        }
        return result;
    }

    public long getSizeOnDisk(SourceIdentifier sourceIdentifier) {
        File indexFile = this.logFileFactory.getIndexFile(sourceIdentifier);
        File dataFile = this.logFileFactory.getDataFile(sourceIdentifier);
        long indexSize = indexFile.length();
        long dataSize = dataFile.length();
        return indexSize + dataSize;
    }
}

