/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.stax;

import de.huxhorn.sulky.stax.WhiteSpaceHandling;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;

public class StaxUtilities {
    private static final char TAB = '\t';
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char SPACE = ' ';
    public static final String CDATA_END = "]]>";
    public static final String XML_SCHEMA_INSTANCE_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_INSTANCE_PREFIX = "xsi";
    public static final String XML_SCHEMA_INSTANCE_SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    public static final String NO_PREFIX = "";

    public static String readSimpleTextNodeIfAvailable(XMLStreamReader reader, String namespaceURI, String nodeName) throws XMLStreamException {
        return StaxUtilities.readSimpleTextNodeIfAvailable(reader, namespaceURI, nodeName, WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE);
    }

    public static String readSimpleTextNodeIfAvailable(XMLStreamReader reader, String namespaceURI, String nodeName, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        int type = reader.getEventType();
        String result = null;
        if (1 == type && nodeName.equals(reader.getLocalName()) && (namespaceURI == null && reader.getNamespaceURI() == null || namespaceURI != null && namespaceURI.equals(reader.getNamespaceURI()))) {
            result = StaxUtilities.readText(reader, whiteSpace);
            reader.nextTag();
        }
        return result;
    }

    public static String readText(XMLStreamReader reader) throws XMLStreamException {
        return StaxUtilities.readText(reader, WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE);
    }

    public static String readText(XMLStreamReader reader, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        String result = reader.getElementText();
        result = StaxUtilities.processWhiteSpace(result, whiteSpace);
        return result;
    }

    public static String processWhiteSpace(String string, WhiteSpaceHandling whiteSpace) {
        if (string == null) {
            return null;
        }
        switch (whiteSpace) {
            case PRESERVE_NORMALIZE_NEWLINE: {
                return StaxUtilities.normalizeNewlines(string);
            }
            case REPLACE: {
                return StaxUtilities.replaceWhiteSpace(string);
            }
            case COLLAPSE: {
                return StaxUtilities.collapseWhiteSpace(string);
            }
        }
        return string;
    }

    public static String collapseWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        String replaced = StaxUtilities.replaceWhiteSpace(string);
        char[] chars = replaced.toCharArray();
        StringBuffer result = new StringBuffer(replaced.length());
        boolean needSpace = false;
        for (char c : chars) {
            if (c == ' ') {
                if (result.length() == 0) continue;
                needSpace = true;
                continue;
            }
            if (needSpace) {
                needSpace = false;
                result.append(' ');
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String replaceWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(string);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (c != '\t' && c != '\r' && c != '\n') continue;
            result.setCharAt(i, ' ');
        }
        return result.toString();
    }

    public static String readAttributeValue(XMLStreamReader reader, String namespaceURI, String name) {
        return StaxUtilities.readAttributeValue(reader, namespaceURI, name, WhiteSpaceHandling.COLLAPSE);
    }

    public static String readAttributeValue(XMLStreamReader reader, String namespaceURI, String name, WhiteSpaceHandling whiteSpace) {
        String attributeValue = reader.getAttributeValue(namespaceURI, name);
        if (attributeValue == null) {
            attributeValue = reader.getAttributeValue(null, name);
        }
        return StaxUtilities.processWhiteSpace(attributeValue, whiteSpace);
    }

    public static void writeNamespace(XMLStreamWriter writer, String prefix, String namespaceURI) throws XMLStreamException {
        if (prefix == null || NO_PREFIX.equals(prefix)) {
            writer.writeDefaultNamespace(namespaceURI);
        } else {
            writer.writeNamespace(prefix, namespaceURI);
        }
    }

    public static NamespaceInfo setNamespace(XMLStreamWriter writer, String prefix, String namespaceURI, String defaultPrefix) throws XMLStreamException {
        String p = writer.getPrefix(namespaceURI);
        if (p == null) {
            NamespaceContext nsc = writer.getNamespaceContext();
            if (prefix == null || NO_PREFIX.equals(prefix)) {
                String defaultNamespaceURI = nsc.getNamespaceURI(NO_PREFIX);
                if (defaultNamespaceURI == null || NO_PREFIX.equals(defaultNamespaceURI)) {
                    writer.setDefaultNamespace(namespaceURI);
                    return new NamespaceInfo(null, true);
                }
                return StaxUtilities.resolveNamespacePrefix(writer, nsc, defaultPrefix, namespaceURI);
            }
            return StaxUtilities.resolveNamespacePrefix(writer, nsc, prefix, namespaceURI);
        }
        if (NO_PREFIX.equals(p)) {
            p = null;
        }
        return new NamespaceInfo(p, false);
    }

    private static NamespaceInfo resolveNamespacePrefix(XMLStreamWriter writer, NamespaceContext nsc, String prefix, String namespaceURI) throws XMLStreamException {
        int counter = 1;
        String prefixCandidate = prefix;
        while (true) {
            String ns;
            if (!NO_PREFIX.equals(ns = nsc.getNamespaceURI(prefixCandidate))) {
                writer.setPrefix(prefixCandidate, namespaceURI);
                return new NamespaceInfo(prefixCandidate, true);
            }
            prefixCandidate = prefix + ++counter;
        }
    }

    public static void writeStartElement(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName) throws XMLStreamException {
        if (namespaceURI != null) {
            if (prefix != null && !NO_PREFIX.equals(prefix)) {
                writer.writeStartElement(prefix, nodeName, namespaceURI);
            } else {
                writer.writeStartElement(namespaceURI, nodeName);
            }
        } else {
            writer.writeStartElement(nodeName);
        }
    }

    public static void writeEmptyElement(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName) throws XMLStreamException {
        if (namespaceURI != null) {
            if (prefix != null && !NO_PREFIX.equals(prefix)) {
                writer.writeEmptyElement(prefix, nodeName, namespaceURI);
            } else {
                writer.writeEmptyElement(namespaceURI, nodeName);
            }
        } else {
            writer.writeEmptyElement(nodeName);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, boolean qualified, String prefix, String namespaceURI, String name, String value) throws XMLStreamException {
        StaxUtilities.writeAttribute(writer, qualified, prefix, namespaceURI, name, value, WhiteSpaceHandling.COLLAPSE);
    }

    public static void writeAttribute(XMLStreamWriter writer, boolean qualified, String prefix, String namespaceURI, String name, String value, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        value = StaxUtilities.processWhiteSpace(value, whiteSpace);
        if (qualified && namespaceURI != null) {
            if (prefix == null && !NO_PREFIX.equals(prefix)) {
                writer.writeAttribute(namespaceURI, name, value);
            } else {
                writer.writeAttribute(prefix, namespaceURI, name, value);
            }
        } else {
            writer.writeAttribute(name, value);
        }
    }

    public static void writeAttributeIfNotNull(XMLStreamWriter writer, boolean qualified, String prefix, String namespaceURI, String name, String value) throws XMLStreamException {
        StaxUtilities.writeAttributeIfNotNull(writer, qualified, prefix, namespaceURI, name, value, WhiteSpaceHandling.COLLAPSE);
    }

    public static void writeAttributeIfNotNull(XMLStreamWriter writer, boolean qualified, String prefix, String namespaceURI, String name, String value, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        if (value != null) {
            StaxUtilities.writeAttribute(writer, qualified, prefix, namespaceURI, name, value, whiteSpace);
        }
    }

    public static String normalizeNewlines(String input) {
        String result = input;
        if (input != null) {
            char[] chars = input.toCharArray();
            int length = chars.length;
            int startWritePos = 0;
            StringBuffer resultBuffer = null;
            int previousChar = 0;
            block4: for (int index = 0; index < length; ++index) {
                int ch = chars[index];
                switch (ch) {
                    case 13: {
                        if (resultBuffer == null) {
                            resultBuffer = new StringBuffer();
                        }
                        resultBuffer.append(chars, startWritePos, index - startWritePos);
                        if (previousChar != 10) {
                            resultBuffer.append("\n");
                            previousChar = ch;
                        } else {
                            previousChar = 0;
                        }
                        startWritePos = index + 1;
                        continue block4;
                    }
                    case 10: {
                        if (resultBuffer == null) {
                            resultBuffer = new StringBuffer();
                        }
                        resultBuffer.append(chars, startWritePos, index - startWritePos);
                        if (previousChar != 13) {
                            resultBuffer.append("\n");
                            previousChar = ch;
                        } else {
                            previousChar = 0;
                        }
                        startWritePos = index + 1;
                        continue block4;
                    }
                    default: {
                        previousChar = 0;
                    }
                }
            }
            if (resultBuffer != null) {
                resultBuffer.append(chars, startWritePos, length - startWritePos);
                result = resultBuffer.toString();
            }
        }
        return result;
    }

    public static void writeSimpleTextNode(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text, WhiteSpaceHandling whiteSpace, boolean tryUsingCData) throws XMLStreamException {
        StaxUtilities.writeStartElement(writer, prefix, namespaceURI, nodeName);
        StaxUtilities.writeText(writer, text, whiteSpace, tryUsingCData);
        writer.writeEndElement();
    }

    public static void writeSimpleTextNode(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        StaxUtilities.writeSimpleTextNode(writer, prefix, namespaceURI, nodeName, text, whiteSpace, false);
    }

    public static void writeSimpleTextNode(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text) throws XMLStreamException {
        StaxUtilities.writeSimpleTextNode(writer, prefix, namespaceURI, nodeName, text, WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE, false);
    }

    public static void writeSimpleTextNodeIfNotNull(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text, WhiteSpaceHandling whiteSpace, boolean tryUsingCData) throws XMLStreamException {
        if (text != null) {
            StaxUtilities.writeSimpleTextNode(writer, prefix, namespaceURI, nodeName, text, whiteSpace, tryUsingCData);
        }
    }

    public static void writeSimpleTextNodeIfNotNull(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text, WhiteSpaceHandling whiteSpace) throws XMLStreamException {
        if (text != null) {
            StaxUtilities.writeSimpleTextNode(writer, prefix, namespaceURI, nodeName, text, whiteSpace, false);
        }
    }

    public static void writeSimpleTextNodeIfNotNull(XMLStreamWriter writer, String prefix, String namespaceURI, String nodeName, String text) throws XMLStreamException {
        if (text != null) {
            StaxUtilities.writeSimpleTextNode(writer, prefix, namespaceURI, nodeName, text, WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE, false);
        }
    }

    public static void writeText(XMLStreamWriter writer, String text, WhiteSpaceHandling whiteSpace, boolean tryUsingCData) throws XMLStreamException {
        StaxUtilities.processWhiteSpace(text, whiteSpace);
        if (tryUsingCData && !text.contains(CDATA_END)) {
            writer.writeCData(text);
        } else {
            writer.writeCharacters(text);
        }
    }

    public static void writeText(XMLStreamWriter writer, String text) throws XMLStreamException {
        StaxUtilities.writeText(writer, text, WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE, false);
    }

    public static String getEventTypeString(int eventType) {
        switch (eventType) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return "<uknown type!>";
    }

    public static void logWriter(Logger logger, String msg, XMLStreamWriter writer, String namespaceURI) {
        if (logger.isDebugEnabled()) {
            StringBuffer msgBuf = new StringBuffer();
            NamespaceContext nsc = writer.getNamespaceContext();
            Iterator<String> iter = nsc.getPrefixes(namespaceURI);
            if (msg != null) {
                msgBuf.append(msg).append(" - ");
            }
            msgBuf.append("Prefixes defined for namespace ").append(namespaceURI).append(":");
            if (iter.hasNext()) {
                boolean isFirst = true;
                while (iter.hasNext()) {
                    if (!isFirst) {
                        msgBuf.append(", ");
                    } else {
                        isFirst = false;
                    }
                    msgBuf.append("'").append((Object)iter.next()).append("'");
                }
            } else {
                msgBuf.append("Undefined.");
            }
            logger.debug(msgBuf.toString());
        }
    }

    public static void logReader(Logger logger, String msg, XMLStreamReader reader) {
        if (logger.isDebugEnabled()) {
            int type = reader.getEventType();
            StringBuffer msgBuf = new StringBuffer(msg);
            msgBuf.append("\n");
            msgBuf.append("\t").append("eventType=").append(StaxUtilities.getEventTypeString(type)).append("\n");
            if (type == 1 || type == 2) {
                msgBuf.append("\t").append("localName=").append(reader.getLocalName()).append("\n");
                msgBuf.append("\t").append("namespaceURI=").append(reader.getNamespaceURI()).append("\n");
            }
            if (type == 1) {
                int attCount = reader.getAttributeCount();
                msgBuf.append("\t").append("attributeCount=").append(attCount).append("\n");
                for (int i = 0; i < attCount; ++i) {
                    msgBuf.append("\t\t").append("#####\n");
                    msgBuf.append("\t\t").append("attributeNamespace=").append(reader.getAttributeNamespace(i)).append("\n");
                    msgBuf.append("\t\t").append("attributeLocalName=").append(reader.getAttributeLocalName(i)).append("\n");
                    msgBuf.append("\t\t").append("attributeValue=").append(reader.getAttributeValue(i)).append("\n");
                    msgBuf.append("\t\t").append("attributePrefix=").append(reader.getAttributePrefix(i)).append("\n");
                }
            }
            msgBuf.append("\treaderClass: ").append(reader.getClass().getName());
            logger.debug(msgBuf.toString());
        }
    }

    public static class NamespaceInfo {
        private String prefix;
        private boolean created;

        public NamespaceInfo(String prefix, boolean created) {
            this.prefix = prefix;
            this.created = created;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

