/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.sourceproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventProducer;
import de.huxhorn.lilith.engine.EventSourceProducer;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerSocketEventSourceProducer<T extends Serializable>
implements EventSourceProducer<T>,
Runnable {
    final Logger logger = LoggerFactory.getLogger(AbstractServerSocketEventSourceProducer.class);
    private ServerSocket serverSocket;
    private AppendOperation<EventWrapper<T>> queue;
    private SimpleDateFormat dateFormat;
    private SourceManager<T> sourceManager;
    private int port;

    public AbstractServerSocketEventSourceProducer(int port) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
    }

    @Override
    public AppendOperation<EventWrapper<T>> getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(AppendOperation<EventWrapper<T>> queue) {
        this.queue = queue;
    }

    @Override
    public SourceManager<T> getSourceManager() {
        return this.sourceManager;
    }

    @Override
    public void setSourceManager(SourceManager<T> sourceManager) {
        this.sourceManager = sourceManager;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void run() {
        while (true) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Closing serverSocket because of exception.", (Throwable)e);
                }
                try {
                    if (this.serverSocket == null) break;
                    this.serverSocket.close();
                }
                catch (IOException e1) {
                    if (!this.logger.isInfoEnabled()) break;
                    this.logger.info("Exception while closing serverSocket.");
                }
                break;
            }
            try {
                SourceIdentifier id = this.createSourceIdentifier(socket);
                EventProducer producer = this.createProducer(id, this.queue, socket.getInputStream());
                producer.start();
                this.sourceManager.addEventProducer(producer);
            }
            catch (Throwable e) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Exception while creating EventProducer.", e);
            }
        }
    }

    private SourceIdentifier createSourceIdentifier(Socket socket) {
        String primary;
        SocketAddress address = socket.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            InetAddress inetAddress = inetSocketAddress.getAddress();
            primary = inetAddress.getHostAddress();
        } else {
            primary = "" + address;
        }
        String secondary = this.dateFormat.format(new Date());
        return new SourceIdentifier(primary, secondary);
    }

    protected abstract EventProducer createProducer(SourceIdentifier var1, AppendOperation<EventWrapper<T>> var2, InputStream var3) throws IOException;
}

