/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.util.Arrays;

public class MessageFormatter {
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';

    public static String format(String messagePattern, String[] arguments) {
        if (arguments == null || messagePattern == null) {
            return messagePattern;
        }
        StringBuilder result = new StringBuilder();
        int escapeCounter = 0;
        int currentArgument = 0;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (curChar == '{') {
                int j;
                if (escapeCounter % 2 == 1) {
                    int escapedEscapes = escapeCounter / 2;
                    for (j = 0; j < escapedEscapes; ++j) {
                        result.append('\\');
                    }
                    result.append('{');
                    escapeCounter = 0;
                    continue;
                }
                boolean brokenPlaceholder = false;
                if (i < messagePattern.length() - 1) {
                    if (messagePattern.charAt(i + 1) == '}') {
                        int escapedEscapes = escapeCounter / 2;
                        for (int j2 = 0; j2 < escapedEscapes; ++j2) {
                            result.append('\\');
                        }
                        escapeCounter = 0;
                        if (currentArgument < arguments.length) {
                            result.append(arguments[currentArgument]);
                        } else {
                            result.append('{').append('}');
                        }
                        ++currentArgument;
                        ++i;
                    } else {
                        brokenPlaceholder = true;
                    }
                } else {
                    brokenPlaceholder = true;
                }
                if (!brokenPlaceholder) continue;
                for (j = 0; j < escapeCounter; ++j) {
                    result.append('\\');
                }
                result.append(messagePattern.substring(i, messagePattern.length()));
                return result.toString();
            }
            if (escapeCounter > 0) {
                for (int j = 0; j < escapeCounter; ++j) {
                    result.append('\\');
                }
                escapeCounter = 0;
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static int countArgumentPlaceholders(String messagePattern) {
        if (messagePattern == null) {
            return 0;
        }
        int delim = messagePattern.indexOf(123);
        if (delim == -1) {
            return 0;
        }
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && i < messagePattern.length() - 1) {
                    if (messagePattern.charAt(i + 1) == '}') {
                        ++result;
                        ++i;
                    } else {
                        return result;
                    }
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return result;
    }

    public static ArgumentResult evaluateArguments(String messagePattern, Object[] arguments) {
        if (arguments == null) {
            return null;
        }
        int argsCount = MessageFormatter.countArgumentPlaceholders(messagePattern);
        int resultArgCount = arguments.length;
        Throwable throwable = null;
        if (argsCount < arguments.length && arguments[arguments.length - 1] instanceof Throwable) {
            throwable = (Throwable)arguments[arguments.length - 1];
            --resultArgCount;
        }
        String[] stringArgs = new String[resultArgCount];
        for (int i = 0; i < stringArgs.length; ++i) {
            Object o = arguments[i];
            if (o == null) continue;
            String argStr = o.getClass().isArray() ? (o instanceof byte[] ? Arrays.toString((byte[])o) : (o instanceof short[] ? Arrays.toString((short[])o) : (o instanceof int[] ? Arrays.toString((int[])o) : (o instanceof long[] ? Arrays.toString((long[])o) : (o instanceof float[] ? Arrays.toString((float[])o) : (o instanceof double[] ? Arrays.toString((double[])o) : (o instanceof boolean[] ? Arrays.toString((boolean[])o) : (o instanceof char[] ? Arrays.toString((char[])o) : Arrays.deepToString((Object[])o))))))))) : (o instanceof String ? (String)o : o.toString());
            stringArgs[i] = argStr;
        }
        return new ArgumentResult(stringArgs, throwable);
    }

    public static class ArgumentResult {
        private Throwable throwable;
        private String[] arguments;

        public ArgumentResult(String[] arguments, Throwable throwable) {
            this.throwable = throwable;
            this.arguments = arguments;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Result[throwable=").append(this.throwable);
            result.append(", arguments=");
            if (this.arguments != null) {
                result.append("[");
                boolean isFirst = true;
                for (String current : this.arguments) {
                    if (!isFirst) {
                        result.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (current != null) {
                        result.append("'").append(current).append("'");
                        continue;
                    }
                    result.append("null");
                }
                result.append("]");
            }
            return result.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentResult result = (ArgumentResult)o;
            if (!Arrays.equals(this.arguments, result.arguments)) {
                return false;
            }
            return !(this.throwable != null ? !this.throwable.equals(result.throwable) : result.throwable != null);
        }

        public int hashCode() {
            int result = this.throwable != null ? this.throwable.hashCode() : 0;
            result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
            return result;
        }
    }
}

