/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
implements Serializable {
    private String name;
    private Map<String, Marker> children;

    public Marker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Markername must not be null!");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Marker> getChildren() {
        if (this.children == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.children);
    }

    public void remove(Marker marker) {
        if (this.children != null) {
            this.children.remove(marker.getName());
        }
    }

    public void add(Marker marker) {
        if (this.children == null) {
            this.children = new HashMap<String, Marker>();
        }
        if (!this.children.containsKey(marker.getName())) {
            this.children.put(marker.getName(), marker);
        }
    }

    public void setChildren(Map<String, Marker> children) {
        this.children = children;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() != 0;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(other.name)) {
            return true;
        }
        if (this.hasChildren()) {
            Set<String> collectedMarkers = this.collectChildMarkerNames(this, null);
            return collectedMarkers.contains(other.getName());
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            return false;
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasChildren()) {
            Set<String> collectedMarkerNames = this.collectChildMarkerNames(this, null);
            return collectedMarkerNames.contains(name);
        }
        return false;
    }

    private Set<String> collectChildMarkerNames(Marker marker, Set<String> collectedMarkerNames) {
        if (collectedMarkerNames == null) {
            collectedMarkerNames = new HashSet<String>();
        }
        if (!collectedMarkerNames.contains(marker.getName())) {
            collectedMarkerNames.add(marker.getName());
            if (marker.hasChildren()) {
                for (Map.Entry<String, Marker> current : marker.getChildren().entrySet()) {
                    Marker child = current.getValue();
                    if (collectedMarkerNames.contains(child.getName())) continue;
                    this.collectChildMarkerNames(child, collectedMarkerNames);
                }
            }
        }
        return collectedMarkerNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Marker marker = (Marker)o;
        return !(this.name == null ? marker.name != null : !this.name.equals(marker.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }
}

