/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TimeoutOutputStream
extends OutputStream {
    private OutputStream stream;
    private int timeout;
    private AtomicLong operationStartTime;
    private AtomicBoolean closed;

    public TimeoutOutputStream(OutputStream stream, int timeout) {
        if (stream == null) {
            throw new NullPointerException("stream must not be null!");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be a positive value!");
        }
        this.stream = stream;
        this.timeout = timeout;
        this.operationStartTime = new AtomicLong(-1L);
        this.closed = new AtomicBoolean(false);
        TimeoutRunnable timeoutRunnable = new TimeoutRunnable();
        Thread t = new Thread((Runnable)timeoutRunnable, "TimeoutOutputStream Watchdog-Thread");
        t.start();
    }

    public void write(byte[] b) throws IOException {
        this.operationStartTime.set(System.currentTimeMillis());
        this.stream.write(b);
        this.operationStartTime.set(-1L);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.operationStartTime.set(System.currentTimeMillis());
        this.stream.write(b, off, len);
        this.operationStartTime.set(-1L);
    }

    public void write(int b) throws IOException {
        this.operationStartTime.set(System.currentTimeMillis());
        this.stream.write(b);
        this.operationStartTime.set(-1L);
    }

    public void flush() throws IOException {
        this.operationStartTime.set(System.currentTimeMillis());
        this.stream.flush();
        this.operationStartTime.set(-1L);
    }

    public void close() throws IOException {
        this.internalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.closed.set(true);
        }
    }

    private class TimeoutRunnable
    implements Runnable {
        private TimeoutRunnable() {
        }

        public void run() {
            try {
                while (!TimeoutOutputStream.this.closed.get()) {
                    long start = TimeoutOutputStream.this.operationStartTime.get();
                    if (start >= 0L) {
                        long since = System.currentTimeMillis() - start;
                        if (since > (long)TimeoutOutputStream.this.timeout) {
                            TimeoutOutputStream.this.internalClose();
                            break;
                        }
                        Thread.sleep((long)TimeoutOutputStream.this.timeout - since);
                        continue;
                    }
                    Thread.sleep(TimeoutOutputStream.this.timeout);
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

