/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.buffers;

import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingFileBuffer<E>
implements FileBuffer<E> {
    private final Logger logger = LoggerFactory.getLogger(SerializingFileBuffer.class);
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private File serializeFile;
    private File serializeIndexFile;
    private static final String INDEX_EXTENSION = ".index";

    public SerializingFileBuffer(File serializeFile) {
        this(serializeFile, null);
    }

    public SerializingFileBuffer(File serializeFile, File serializeIndexFile) {
        this.setSerializeFile(serializeFile);
        if (serializeIndexFile == null) {
            File parent = serializeFile.getParentFile();
            String indexName = serializeFile.getName();
            int dotIndex = indexName.lastIndexOf(46);
            if (dotIndex > 0) {
                indexName = indexName.substring(0, dotIndex);
            }
            indexName = indexName + INDEX_EXTENSION;
            serializeIndexFile = new File(parent, indexName);
        }
        this.setSerializeIndexFile(serializeIndexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        RandomAccessFile raf = null;
        Lock lock = this.readWriteLock.readLock();
        lock.lock();
        try {
            if (!this.serializeIndexFile.canRead()) {
                long l = 0L;
                return l;
            }
            raf = new RandomAccessFile(this.serializeIndexFile, "r");
            long l = this.internalGetSize(raf);
            SerializingFileBuffer.closeQuietly(raf);
            lock.unlock();
            return l;
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Couldn't retrieve size!", (Throwable)e);
            }
            long l = 0L;
            return l;
        }
        finally {
            SerializingFileBuffer.closeQuietly(raf);
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E get(long index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E element) {
        RandomAccessFile randomSerializeIndexFile = null;
        RandomAccessFile randomSerializeFile = null;
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            randomSerializeIndexFile = new RandomAccessFile(this.serializeIndexFile, "rw");
            randomSerializeFile = new RandomAccessFile(this.serializeFile, "rw");
            long elementsCount = this.internalGetSize(randomSerializeIndexFile);
            long offset = 0L;
            if (elementsCount > 0L) {
                long prevElement = elementsCount - 1L;
                offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
            }
            this.internalWriteElement(randomSerializeFile, offset, element);
            this.internalWriteOffset(randomSerializeIndexFile, elementsCount, offset);
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!this.logger.isWarnEnabled()) break block5;
                    this.logger.warn("Couldn't write element!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SerializingFileBuffer.closeQuietly(randomSerializeFile);
                    SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
                    lock.unlock();
                    throw throwable;
                }
            }
            SerializingFileBuffer.closeQuietly(randomSerializeFile);
            SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
            lock.unlock();
        }
        SerializingFileBuffer.closeQuietly(randomSerializeFile);
        SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAll(List<E> elements) {
        int newElementCount;
        if (elements != null && (newElementCount = elements.size()) > 0) {
            Lock lock;
            RandomAccessFile randomSerializeFile;
            RandomAccessFile randomSerializeIndexFile;
            block8: {
                randomSerializeIndexFile = null;
                randomSerializeFile = null;
                lock = this.readWriteLock.writeLock();
                lock.lock();
                try {
                    randomSerializeIndexFile = new RandomAccessFile(this.serializeIndexFile, "rw");
                    randomSerializeFile = new RandomAccessFile(this.serializeFile, "rw");
                    long elementsCount = this.internalGetSize(randomSerializeIndexFile);
                    long offset = 0L;
                    if (elementsCount > 0L) {
                        long prevElement = elementsCount - 1L;
                        offset = this.internalOffsetOfElement(randomSerializeIndexFile, prevElement);
                        offset = offset + this.internalReadElementSize(randomSerializeFile, offset) + 4L;
                    }
                    long[] offsets = new long[elements.size()];
                    int index = 0;
                    for (E element : elements) {
                        offsets[index] = offset;
                        offset = offset + (long)this.internalWriteElement(randomSerializeFile, offset, element) + 4L;
                        ++index;
                    }
                    index = 0;
                    for (long curOffset : offsets) {
                        this.internalWriteOffset(randomSerializeIndexFile, elementsCount + (long)index, curOffset);
                        ++index;
                    }
                    if (!this.logger.isInfoEnabled()) break block8;
                    this.logger.info("Elements after batch-write: {}", (Object)((long)index + elementsCount));
                }
                catch (IOException e) {
                    block9: {
                        try {
                            if (!this.logger.isWarnEnabled()) break block9;
                            this.logger.warn("Couldn't write element!", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SerializingFileBuffer.closeQuietly(randomSerializeFile);
                            SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
                            lock.unlock();
                            throw throwable;
                        }
                    }
                    SerializingFileBuffer.closeQuietly(randomSerializeFile);
                    SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
                    lock.unlock();
                }
            }
            SerializingFileBuffer.closeQuietly(randomSerializeFile);
            SerializingFileBuffer.closeQuietly(randomSerializeIndexFile);
            lock.unlock();
        }
    }

    @Override
    public void addAll(E[] elements) {
        this.addAll(Arrays.asList(elements));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Lock lock = this.readWriteLock.writeLock();
        lock.lock();
        try {
            this.serializeIndexFile.delete();
            this.serializeFile.delete();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new BasicBufferIterator(this);
    }

    private static void closeQuietly(RandomAccessFile raf) {
        block3: {
            Logger logger = LoggerFactory.getLogger(SerializingFileBuffer.class);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Close on random access file threw exception!", (Throwable)e);
                }
            }
        }
    }

    private long internalOffsetOfElement(RandomAccessFile randomSerializeIndexFile, long index) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset + 8L) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        long result = randomSerializeIndexFile.readLong();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Offset of element {}: {}", (Object)index, (Object)result);
        }
        return result;
    }

    private long internalGetSize(RandomAccessFile randomSerializeIndexFile) throws IOException {
        long result = randomSerializeIndexFile.length() / 8L;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("size={}", (Object)result);
        }
        return result;
    }

    private E internalReadElement(RandomAccessFile randomSerializeFile, long offset) throws IOException, ClassNotFoundException, ClassCastException {
        if (randomSerializeFile.length() < offset + 4L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + offset + "! Couldn't read length of data!");
        }
        randomSerializeFile.seek(offset);
        int bufferSize = randomSerializeFile.readInt();
        if (randomSerializeFile.length() < offset + 4L + (long)bufferSize) {
            throw new IndexOutOfBoundsException("Invalid length (" + bufferSize + ") at offset: " + offset + "!");
        }
        byte[] buffer = new byte[bufferSize];
        randomSerializeFile.readFully(buffer);
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
        GZIPInputStream gis = new GZIPInputStream(bis);
        ObjectInputStream ois = new ObjectInputStream(gis);
        Object result = ois.readObject();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Read element from offset {}.", (Object)offset);
        }
        return (E)result;
    }

    private void internalWriteOffset(RandomAccessFile randomSerializeIndexFile, long index, long offset) throws IOException {
        long offsetOffset = 8L * index;
        if (randomSerializeIndexFile.length() < offsetOffset) {
            throw new IOException("Invalid offsetOffset " + offsetOffset + "!");
        }
        randomSerializeIndexFile.seek(offsetOffset);
        randomSerializeIndexFile.writeLong(offset);
    }

    private int internalWriteElement(RandomAccessFile randomSerializeFile, long offset, E element) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        CountingOutputStream cos = new CountingOutputStream((OutputStream)gos);
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)cos);
        out.writeObject(element);
        out.flush();
        out.close();
        gos.finish();
        byte[] buffer = bos.toByteArray();
        int uncompressed = cos.getCount();
        int bufferSize = buffer.length;
        if (this.logger.isDebugEnabled()) {
            int packedPercent = (int)((double)bufferSize / (double)uncompressed * 100.0);
            this.logger.debug("Uncompressed size: {}", (Object)uncompressed);
            this.logger.debug("Compressed size  : {} ({}%)", (Object)bufferSize, (Object)packedPercent);
        }
        randomSerializeFile.seek(offset);
        randomSerializeFile.writeInt(bufferSize);
        randomSerializeFile.write(buffer);
        return bufferSize;
    }

    private long internalReadElementSize(RandomAccessFile randomSerializeFile, long offset) throws IOException {
        randomSerializeFile.seek(offset);
        return randomSerializeFile.readInt();
    }

    private void setSerializeFile(File serializeFile) {
        this.prepareFile(serializeFile);
        this.serializeFile = serializeFile;
    }

    private void setSerializeIndexFile(File serializeIndexFile) {
        this.prepareFile(serializeIndexFile);
        this.serializeIndexFile = serializeIndexFile;
    }

    private void prepareFile(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IllegalArgumentException(parent.getAbsolutePath() + " is not a directory!");
            }
            if (file.isFile() && !file.canWrite()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not writable!");
            }
        }
    }
}

