/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.eventsource.xml;

import de.huxhorn.lilith.data.eventsource.SourceInfo;
import de.huxhorn.lilith.data.eventsource.xml.EventSourceSchemaConstants;
import de.huxhorn.lilith.data.eventsource.xml.SourceIdentifierReader;
import de.huxhorn.sulky.stax.DateTimeFormatter;
import de.huxhorn.sulky.stax.GenericStreamReader;
import de.huxhorn.sulky.stax.StaxUtilities;
import java.text.ParseException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceInfoReader
implements GenericStreamReader<SourceInfo>,
EventSourceSchemaConstants {
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private SourceIdentifierReader sourceIdentifierReader = new SourceIdentifierReader();
    private static final String TRUE = "true";
    private static final String ONE = "1";

    public SourceInfo read(XMLStreamReader reader) throws XMLStreamException {
        SourceInfo result = null;
        String rootNamespace = "http://lilith.sf.net/schema/eventsource/10";
        int type = reader.getEventType();
        if (7 == type) {
            reader.nextTag();
            type = reader.getEventType();
            rootNamespace = null;
        }
        if (1 == type && "EventSourceInfo".equals(reader.getLocalName())) {
            result = new SourceInfo();
            result.setNumberOfEvents(Long.parseLong(StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/eventsource/10", (String)"numberOfEvents")));
            String dateTime = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/eventsource/10", (String)"oldestEventTimestamp");
            if (dateTime != null && !"".equals(dateTime.trim())) {
                try {
                    Date ts = this.dateTimeFormatter.parse(dateTime);
                    result.setOldestEventTimestamp(ts);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            String activeStr = StaxUtilities.readAttributeValue((XMLStreamReader)reader, (String)"http://lilith.sf.net/schema/eventsource/10", (String)"active");
            boolean active = false;
            if (TRUE.equals(activeStr) || ONE.equals(activeStr)) {
                active = true;
            }
            result.setActive(active);
            reader.nextTag();
            result.setSource(this.sourceIdentifierReader.read(reader));
            reader.require(2, "http://lilith.sf.net/schema/eventsource/10", "SourceIdentifier");
            reader.nextTag();
            reader.require(2, rootNamespace, "EventSourceInfo");
        }
        return result;
    }
}

