/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.generics.io;

import de.huxhorn.sulky.generics.io.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableSerializer<E extends Serializable>
implements Serializer<E> {
    boolean compressing;

    public SerializableSerializer() {
        this(false);
    }

    public SerializableSerializer(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(E object) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            byte[] result;
            if (this.compressing) {
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                oos = new ObjectOutputStream(gos);
            } else {
                oos = new ObjectOutputStream(bos);
            }
            oos.writeObject(object);
            oos.flush();
            oos.close();
            byArray = result = bos.toByteArray();
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                e.printStackTrace();
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
            IOUtils.closeQuietly((OutputStream)bos);
            return byArray2;
        }
        IOUtils.closeQuietly((OutputStream)oos);
        IOUtils.closeQuietly((OutputStream)bos);
        return byArray;
    }
}

