/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.xml.LoggingEventSchemaConstants;
import de.huxhorn.sulky.stax.DateTimeFormatter;
import de.huxhorn.sulky.stax.GenericStreamWriter;
import de.huxhorn.sulky.stax.StaxUtilities;
import de.huxhorn.sulky.stax.WhiteSpaceHandling;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventWriter
implements GenericStreamWriter<LoggingEvent>,
LoggingEventSchemaConstants {
    private String preferredPrefix;
    private String prefix;
    private boolean sortingMdcValues;
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private boolean writingSchemaLocation;

    public boolean isSortingMdcValues() {
        return this.sortingMdcValues;
    }

    public void setSortingMdcValues(boolean sortingMdcValues) {
        this.sortingMdcValues = sortingMdcValues;
    }

    public boolean isWritingSchemaLocation() {
        return this.writingSchemaLocation;
    }

    public void setWritingSchemaLocation(boolean writingSchemaLocation) {
        this.writingSchemaLocation = writingSchemaLocation;
    }

    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }

    public void setPreferredPrefix(String prefix) {
        this.preferredPrefix = prefix;
    }

    public void write(XMLStreamWriter writer, LoggingEvent event, boolean isRoot) throws XMLStreamException {
        if (isRoot) {
            writer.writeStartDocument("utf-8", "1.0");
        }
        StaxUtilities.NamespaceInfo ni = StaxUtilities.setNamespace((XMLStreamWriter)writer, (String)this.preferredPrefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"log");
        this.prefix = ni.getPrefix();
        StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"LoggingEvent");
        if (ni.isCreated()) {
            StaxUtilities.writeNamespace((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10");
        }
        if (isRoot && this.writingSchemaLocation) {
            ni = StaxUtilities.setNamespace((XMLStreamWriter)writer, (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"xsi");
            if (ni.isCreated()) {
                StaxUtilities.writeNamespace((XMLStreamWriter)writer, (String)ni.getPrefix(), (String)"http://www.w3.org/2001/XMLSchema-instance");
            }
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)true, (String)ni.getPrefix(), (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"schemaLocation", (String)"http://lilith.sf.net/schema/logging/10 http://lilith.sf.net/schema/logging/10/LoggingEvent.xsd");
        }
        StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"logger", (String)event.getLogger());
        StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"level", (String)("" + event.getLevel()));
        StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"applicationId", (String)event.getApplicationIdentifier());
        StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"threadName", (String)event.getThreadName());
        StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"timeStamp", (String)this.dateTimeFormatter.format(event.getTimeStamp()));
        StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Message", (String)event.getMessagePattern());
        this.writeArguments(writer, event);
        this.writeThrowable(writer, event);
        this.writeMdc(writer, event);
        this.writeMarker(writer, event);
        this.writeCallStack(writer, event);
        writer.writeEndElement();
        if (isRoot) {
            writer.writeEndDocument();
        }
    }

    private void writeCallStack(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        this.writeStackTraceNode(writer, event.getCallStack(), "CallStack");
    }

    private void writeMarker(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        Marker marker = event.getMarker();
        if (marker != null) {
            ArrayList<String> handledMarkers = new ArrayList<String>();
            this.writeMarkerNode(writer, marker, handledMarkers);
        }
    }

    private void writeMarkerNode(XMLStreamWriter writer, Marker marker, List<String> handledMarkers) throws XMLStreamException {
        String markerName = marker.getName();
        if (handledMarkers.contains(markerName)) {
            StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"MarkerReference");
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"ref", (String)markerName);
        } else {
            handledMarkers.add(markerName);
            boolean hasChildren = marker.hasChildren();
            if (hasChildren) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Marker");
            } else {
                StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Marker");
            }
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"name", (String)markerName);
            if (hasChildren) {
                Map children = marker.getChildren();
                for (Map.Entry current : children.entrySet()) {
                    this.writeMarkerNode(writer, (Marker)current.getValue(), handledMarkers);
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeMdc(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        TreeMap mdc = event.getMdc();
        if (mdc != null) {
            if (this.sortingMdcValues) {
                mdc = new TreeMap(mdc);
            }
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"MDC");
            for (Map.Entry entry : mdc.entrySet()) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Entry");
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"key", (String)((String)entry.getKey()), (WhiteSpaceHandling)WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE);
                StaxUtilities.writeText((XMLStreamWriter)writer, (String)((String)entry.getValue()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeArguments(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        String[] arguments = event.getArguments();
        if (arguments != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Arguments");
            for (String current : arguments) {
                if (current == null) {
                    StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"null");
                    continue;
                }
                StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Argument", (String)current);
            }
            writer.writeEndElement();
        }
    }

    private void writeThrowable(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        ThrowableInfo throwable = event.getThrowable();
        this.writeThrowableNode(writer, throwable, "Throwable");
    }

    private void writeThrowableNode(XMLStreamWriter writer, ThrowableInfo throwable, String nodeName) throws XMLStreamException {
        if (throwable != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)nodeName);
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"name", (String)throwable.getName());
            StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Message", (String)throwable.getMessage());
            this.writeStackTraceNode(writer, throwable.getStackTrace(), "StackTrace");
            this.writeThrowableNode(writer, throwable.getCause(), "Cause");
            writer.writeEndElement();
        }
    }

    private void writeStackTraceNode(XMLStreamWriter writer, StackTraceElement[] ste, String nodeName) throws XMLStreamException {
        if (ste != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)nodeName);
            for (StackTraceElement elem : ste) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"StackTraceElement");
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"className", (String)elem.getClassName());
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"methodName", (String)elem.getMethodName());
                StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"fileName", (String)elem.getFileName());
                int lineNumber = elem.getLineNumber();
                if (lineNumber == -2) {
                    StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"Native");
                } else if (lineNumber >= 0) {
                    StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/10", (String)"LineNumber", (String)("" + lineNumber));
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

