/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.rrd4j.cmd.RrdCreateCmd;
import org.rrd4j.cmd.RrdDumpCmd;
import org.rrd4j.cmd.RrdFetchCmd;
import org.rrd4j.cmd.RrdGraphCmd;
import org.rrd4j.cmd.RrdInfoCmd;
import org.rrd4j.cmd.RrdLastCmd;
import org.rrd4j.cmd.RrdRestoreCmd;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.cmd.RrdTuneCmd;
import org.rrd4j.cmd.RrdUpdateCmd;
import org.rrd4j.cmd.RrdXportCmd;

public class RrdCommander {
    private static final RrdToolCmd[] rrdCommands = new RrdToolCmd[]{new RrdCreateCmd(), new RrdUpdateCmd(), new RrdLastCmd(), new RrdFetchCmd(), new RrdDumpCmd(), new RrdRestoreCmd(), new RrdXportCmd(), new RrdGraphCmd(), new RrdTuneCmd(), new RrdInfoCmd()};

    public static synchronized boolean isStandardOutUsed() {
        return RrdToolCmd.isStandardOutUsed();
    }

    public static synchronized void setStandardOutUsed(boolean bl) {
        RrdToolCmd.setStandardOutUsed(bl);
    }

    public static synchronized boolean isRrdDbPoolUsed() {
        return RrdToolCmd.isRrdDbPoolUsed();
    }

    public static synchronized void setRrdDbPoolUsed(boolean bl) {
        RrdToolCmd.setRrdDbPoolUsed(bl);
    }

    public static synchronized Object execute(String string) throws IOException {
        String string2;
        String string3 = string.trim();
        if (string3.startsWith(string2 = "rrdtool ")) {
            string3 = string3.substring(string2.length());
        }
        for (RrdToolCmd rrdToolCmd : rrdCommands) {
            if (!string3.startsWith(rrdToolCmd.getCmdType() + " ")) continue;
            return rrdToolCmd.executeCommand(string3);
        }
        throw new IllegalArgumentException("Unknown RRDTool command: " + string);
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("== Rrd4j's RRDTool commander ==");
        System.out.println("Type a RRDTool command after the dollar sign and press Enter.");
        System.out.println("Start your RRDTool command with 'create', 'update', 'fetch' etc.");
        System.out.println("Start line with 'create', 'update', 'fetch' etc.");
        System.out.println("Enter dot ('.') to bail out");
        System.out.println("Current directory is: " + new File(".").getCanonicalPath());
        System.out.println("================================");
        RrdToolCmd.setRrdDbPoolUsed(false);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("$ ");
                    String string = bufferedReader.readLine().trim();
                    if (string.length() <= 0) continue;
                    if (string.startsWith(".")) break block2;
                    RrdCommander.execute(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

