/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.renderer;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.HttpStatus;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.Colors;
import de.huxhorn.lilith.swing.ColorsProvider;
import de.huxhorn.lilith.swing.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StatusCodeRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer;
    private Map<HttpStatus.Type, Color> backgroundColors = new HashMap<HttpStatus.Type, Color>();
    private Map<HttpStatus.Type, Color> foregroundColors;

    public StatusCodeRenderer() {
        this.backgroundColors.put(HttpStatus.Type.SUCCESSFUL, Color.GREEN);
        this.backgroundColors.put(HttpStatus.Type.INFORMATIONAL, Color.WHITE);
        this.backgroundColors.put(HttpStatus.Type.REDIRECTION, Color.YELLOW);
        this.backgroundColors.put(HttpStatus.Type.CLIENT_ERROR, Color.RED);
        this.backgroundColors.put(HttpStatus.Type.SERVER_ERROR, Color.RED);
        this.foregroundColors = new HashMap<HttpStatus.Type, Color>();
        this.foregroundColors.put(HttpStatus.Type.CLIENT_ERROR, Color.GREEN);
        this.foregroundColors.put(HttpStatus.Type.SERVER_ERROR, Color.YELLOW);
        this.renderer = new LabelCellRenderer();
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        EventWrapper wrapper;
        ColorsProvider cp;
        Colors colors;
        EventWrapper wrapper2;
        Serializable eventObj;
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        Color foreground = Color.BLACK;
        String text = "";
        if (value instanceof EventWrapper && (eventObj = (wrapper2 = (EventWrapper)value).getEvent()) instanceof AccessEvent) {
            AccessEvent event = (AccessEvent)eventObj;
            text = "" + event.getStatusCode();
        }
        this.renderer.setText(text);
        boolean colorsInitialized = false;
        if (!hasFocus && !isSelected && table instanceof ColorsProvider && value instanceof EventWrapper && (colors = (cp = (ColorsProvider)((Object)table)).resolveColors(wrapper = (EventWrapper)value, rowIndex, vColIndex)).isSticky()) {
            colorsInitialized = this.renderer.updateColors(colors);
        }
        if (!colorsInitialized) {
            AccessEvent event;
            int code;
            HttpStatus status;
            Serializable eventObj2;
            this.renderer.setForeground(foreground);
            if (value instanceof EventWrapper && (eventObj2 = (wrapper = (EventWrapper)value).getEvent()) instanceof AccessEvent && (status = HttpStatus.getStatus((int)(code = (event = (AccessEvent)eventObj2).getStatusCode()))) != null) {
                Color c;
                HttpStatus.Type type = status.getType();
                if (this.backgroundColors != null && (c = this.backgroundColors.get(type)) != null) {
                    this.renderer.setBackground(c);
                }
                if (this.foregroundColors != null && (c = this.foregroundColors.get(type)) != null) {
                    this.renderer.setForeground(c);
                }
            }
        }
        return this.renderer;
    }
}

