/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.renderer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.swing.Colors;
import de.huxhorn.lilith.swing.ColorsProvider;
import de.huxhorn.lilith.swing.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class LevelRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer;
    private Map<String, Color> backgroundColors = new HashMap<String, Color>();
    private Map<String, Color> foregroundColors;

    public LevelRenderer() {
        this.backgroundColors.put("TRACE", new Color(128, 186, 217));
        this.backgroundColors.put("DEBUG", Color.GREEN);
        this.backgroundColors.put("INFO", Color.WHITE);
        this.backgroundColors.put("WARN", Color.YELLOW);
        this.backgroundColors.put("ERROR", Color.RED);
        this.foregroundColors = new HashMap<String, Color>();
        this.foregroundColors.put("ERROR", Color.YELLOW);
        this.foregroundColors.put("TRACE", new Color(31, 68, 88));
        this.renderer = new LabelCellRenderer();
        this.renderer.setHorizontalAlignment(0);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        EventWrapper wrapper;
        ColorsProvider cp;
        Colors colors;
        EventWrapper wrapper2;
        Serializable eventObj;
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        String text = "";
        if (value instanceof EventWrapper && (eventObj = (wrapper2 = (EventWrapper)value).getEvent()) instanceof LoggingEvent) {
            LoggingEvent event = (LoggingEvent)eventObj;
            text = "" + event.getLevel();
        }
        this.renderer.setText(text);
        boolean colorsInitialized = false;
        if (!hasFocus && !isSelected && table instanceof ColorsProvider && value instanceof EventWrapper && (colors = (cp = (ColorsProvider)((Object)table)).resolveColors(wrapper = (EventWrapper)value, rowIndex, vColIndex)).isSticky()) {
            colorsInitialized = this.renderer.updateColors(colors);
        }
        if (!colorsInitialized) {
            Color c;
            this.renderer.setForeground(Color.BLACK);
            if (this.backgroundColors != null && (c = this.backgroundColors.get(text)) != null) {
                this.renderer.setBackground(c);
            }
            if (this.foregroundColors != null && (c = this.foregroundColors.get(text)) != null) {
                this.renderer.setForeground(c);
            }
        }
        return this.renderer;
    }
}

