/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.renderer;

import de.huxhorn.lilith.swing.Colors;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

public class LabelCellRenderer
extends JLabel {
    private boolean selected;
    private boolean focused;
    private static final Color FOCUSED_SELECTED_BACKGROUND = new Color(255, 255, 0);
    private static final Color FOCUSED_UNSELECTED_BACKGROUND = new Color(255, 255, 180);

    public LabelCellRenderer() {
        Font font = this.getFont();
        font = font.deriveFont(0);
        this.setFont(font);
    }

    public static int getSelectedRow(JTable table) {
        ListSelectionModel rsm = table.getSelectionModel();
        return rsm.getLeadSelectionIndex();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.initCellProperties();
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        this.initCellProperties();
    }

    private void initCellProperties() {
        if (this.selected) {
            if (this.focused) {
                this.setBackground(FOCUSED_SELECTED_BACKGROUND);
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
            } else {
                this.setBackground(FOCUSED_UNSELECTED_BACKGROUND);
                this.setForeground(UIManager.getColor("Table.foreground"));
            }
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        this.setOpaque(true);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public boolean updateColors(Colors colors) {
        boolean result = false;
        if (colors != null) {
            Color bg;
            Color fg = colors.getForeground();
            if (fg != null) {
                this.setForeground(fg);
                result = true;
            }
            if ((bg = colors.getBackground()) != null) {
                result = true;
                this.setBackground(bg);
            }
        }
        return result;
    }
}

