/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends JPanel {
    private JCheckBox internalFramesCheckbox;
    private JCheckBox scrollingToBottomCheckbox;
    private JCheckBox autoOpenCheckbox;
    private JCheckBox autoCloseCheckbox;
    private JCheckBox autoFocusCheckbox;
    private JFileChooser applicationPathFileChooser;
    private JTextArea appPathTextArea;
    private JCheckBox checkForUpdateCheckbox;
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private JCheckBox showIdentifierCheckbox;

    public GeneralPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.internalFramesCheckbox = new JCheckBox("Use internal frames.");
        this.showIdentifierCheckbox = new JCheckBox("Show identifier for named sources.");
        this.autoOpenCheckbox = new JCheckBox("Automatically open new views on connection.");
        this.autoCloseCheckbox = new JCheckBox("Automatically close inactive views on disconnection.");
        this.autoFocusCheckbox = new JCheckBox("Automatically focus window of new view.");
        this.checkForUpdateCheckbox = new JCheckBox("Check for updates on startup.");
        this.scrollingToBottomCheckbox = new JCheckBox("Initial 'Scrolling to Bottom' setting");
        this.applicationPathFileChooser = new JFileChooser();
        this.applicationPathFileChooser.setFileSelectionMode(1);
        JPanel appPathPanel = new JPanel();
        appPathPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Application Path"));
        this.appPathTextArea = new JTextArea(5, 20);
        this.appPathTextArea.setEditable(false);
        appPathPanel.add(this.appPathTextArea);
        BrowseApplicationPathAction browseAppPathAction = new BrowseApplicationPathAction();
        JButton browseAppPathButton = new JButton(browseAppPathAction);
        appPathPanel.add(browseAppPathButton);
        this.setLayout(new FlowLayout());
        this.add(this.internalFramesCheckbox);
        this.add(this.scrollingToBottomCheckbox);
        this.add(this.showIdentifierCheckbox);
        this.add(this.autoOpenCheckbox);
        this.add(this.autoCloseCheckbox);
        this.add(this.autoFocusCheckbox);
        this.add(this.checkForUpdateCheckbox);
        this.add(appPathPanel);
    }

    public void initUI() {
        this.internalFramesCheckbox.setSelected(this.applicationPreferences.isUsingInternalFrames());
        this.scrollingToBottomCheckbox.setSelected(this.applicationPreferences.isScrollingToBottom());
        this.appPathTextArea.setText(this.applicationPreferences.getApplicationPath().getAbsolutePath());
        this.autoOpenCheckbox.setSelected(this.applicationPreferences.isAutoOpening());
        this.autoCloseCheckbox.setSelected(this.applicationPreferences.isAutoClosing());
        this.autoFocusCheckbox.setSelected(this.applicationPreferences.isAutoFocusingWindow());
        this.checkForUpdateCheckbox.setSelected(this.applicationPreferences.isCheckingForUpdate());
        this.showIdentifierCheckbox.setSelected(this.applicationPreferences.isShowingIdentifier());
    }

    public void saveSettings() {
        this.applicationPreferences.setUsingInternalFrames(this.internalFramesCheckbox.isSelected());
        this.applicationPreferences.setScrollingToBottom(this.scrollingToBottomCheckbox.isSelected());
        this.applicationPreferences.setAutoOpening(this.autoOpenCheckbox.isSelected());
        this.applicationPreferences.setAutoClosing(this.autoCloseCheckbox.isSelected());
        this.applicationPreferences.setAutoFocusingWindow(this.autoFocusCheckbox.isSelected());
        this.applicationPreferences.setCheckingForUpdate(this.checkForUpdateCheckbox.isSelected());
        this.applicationPreferences.setApplicationPath(new File(this.appPathTextArea.getText()));
        this.applicationPreferences.setShowingIdentifier(this.showIdentifierCheckbox.isSelected());
    }

    private class BrowseApplicationPathAction
    extends AbstractAction {
        public BrowseApplicationPathAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/document-open.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Browse for the application path.");
        }

        public void actionPerformed(ActionEvent e) {
            GeneralPanel.this.applicationPathFileChooser.setCurrentDirectory(GeneralPanel.this.applicationPreferences.getApplicationPath());
            int returnVal = GeneralPanel.this.applicationPathFileChooser.showDialog(GeneralPanel.this.preferencesDialog, "Select");
            if (returnVal == 0) {
                File file = GeneralPanel.this.applicationPathFileChooser.getSelectedFile();
                GeneralPanel.this.appPathTextArea.setText(file.getAbsolutePath());
            }
        }
    }
}

