/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.preferences.EditConditionDialog;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.Windows;
import java.awt.BorderLayout;
import java.awt.Window;
import java.util.Map;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiltersPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(FiltersPanel.class);
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private EditConditionDialog editConditionDialog;

    public FiltersPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.editConditionDialog = new EditConditionDialog(this.preferencesDialog);
    }

    public void initUI() {
    }

    public void editCondition(Condition condition) {
        Map<String, Condition> conditions = this.preferencesDialog.getConditions();
        String conditionName = null;
        for (Map.Entry<String, Condition> current : conditions.entrySet()) {
            Condition value = current.getValue();
            if (!value.equals(condition)) continue;
            conditionName = current.getKey();
            break;
        }
        boolean adding = false;
        if (conditionName == null) {
            conditionName = "";
            adding = true;
        }
        this.editConditionDialog.setConditionName(conditionName);
        this.editConditionDialog.setAdding(adding);
        Windows.showWindow((Window)this.editConditionDialog, (Window)this.preferencesDialog, (boolean)true);
        if (!this.editConditionDialog.isCanceled()) {
            String newName = this.editConditionDialog.getConditionName();
            newName = newName.trim();
            conditions.remove(conditionName);
            conditions.put(newName, condition);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Setting conditions to {}.", conditions);
            }
            this.preferencesDialog.setConditions(conditions);
        }
    }
}

