/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSourceNameDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(EditSourceNameDialog.class);
    private JTextField sourceIdentifier;
    private JTextField sourceName;
    private OkAction okAction;
    private boolean adding;
    private boolean canceled;

    public EditSourceNameDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.createUi();
    }

    private void createUi() {
        this.okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        TextKeyListener listener = new TextKeyListener();
        this.sourceIdentifier = new JTextField(25);
        this.sourceIdentifier.addActionListener(new SourceIdentifierActionListener());
        this.sourceIdentifier.addKeyListener(listener);
        this.sourceName = new JTextField(25);
        this.sourceName.addActionListener(new SourceNameActionListener());
        this.sourceName.addKeyListener(listener);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        mainPanel.add((Component)new JLabel("Source: "), gbc);
        gbc.gridx = 1;
        mainPanel.add((Component)this.sourceIdentifier, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        mainPanel.add((Component)new JLabel("Name: "), gbc);
        gbc.gridx = 1;
        mainPanel.add((Component)this.sourceName, gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.okAction));
        buttonPanel.add(new JButton(cancelAction));
        this.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)mainPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    public void setAdding(boolean adding) {
        this.adding = adding;
        if (adding) {
            this.setTitle("Add source name...");
        } else {
            this.setTitle("Edit source name...");
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            if (this.adding) {
                this.sourceIdentifier.requestFocusInWindow();
            } else {
                this.sourceName.selectAll();
                this.sourceName.requestFocusInWindow();
            }
            this.initUI();
        }
        super.setVisible(b);
    }

    private void updateActions() {
        this.okAction.update();
    }

    public boolean isAdding() {
        return this.adding;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setSourceName(String sourceName) {
        this.sourceName.setText(sourceName);
    }

    public String getSourceName() {
        return this.sourceName.getText();
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier.getText();
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier.setText(sourceIdentifier);
    }

    public void initUI() {
        this.updateActions();
    }

    private class TextKeyListener
    implements KeyListener {
        private TextKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            EditSourceNameDialog.this.updateActions();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class SourceIdentifierActionListener
    implements ActionListener {
        private SourceIdentifierActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String source = EditSourceNameDialog.this.sourceIdentifier.getText();
            if (source != null && !"".equals(source.trim())) {
                EditSourceNameDialog.this.sourceName.selectAll();
                EditSourceNameDialog.this.sourceName.requestFocusInWindow();
            }
        }
    }

    private class SourceNameActionListener
    implements ActionListener {
        private SourceNameActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditSourceNameDialog.this.sourceName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditSourceNameDialog.this.okAction.actionPerformed(e);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (EditSourceNameDialog.this.logger.isDebugEnabled()) {
                EditSourceNameDialog.this.logger.debug("accelerator: {}", (Object)accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EditSourceNameDialog.this.canceled = true;
            EditSourceNameDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void update() {
            String source = EditSourceNameDialog.this.sourceIdentifier.getText();
            String name = EditSourceNameDialog.this.sourceName.getText();
            if (name != null && !"".equals(name.trim()) && source != null && !"".equals(source.trim())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String source = EditSourceNameDialog.this.sourceIdentifier.getText();
            if (source != null && !"".equals(source.trim())) {
                EditSourceNameDialog.this.canceled = false;
                EditSourceNameDialog.this.setVisible(false);
            }
        }
    }
}

