/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.preferences.EditSourceNameDialog;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditConditionDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(EditSourceNameDialog.class);
    private JTextField conditionName;
    private OkAction okAction;
    private boolean adding;
    private boolean canceled;

    public EditConditionDialog(Dialog owner) {
        super(owner);
        this.setModal(true);
        this.createUi();
    }

    private void createUi() {
        this.okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        TextKeyListener listener = new TextKeyListener();
        this.conditionName = new JTextField(25);
        this.conditionName.addActionListener(new ConditionNameActionListener());
        this.conditionName.addKeyListener(listener);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        mainPanel.add((Component)new JLabel("Name: "), gbc);
        gbc.gridx = 1;
        mainPanel.add((Component)this.conditionName, gbc);
        this.setLayout(new BorderLayout());
        this.add((Component)mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.okAction));
        buttonPanel.add(new JButton(cancelAction));
        this.add((Component)buttonPanel, "South");
        KeyStrokes.registerCommand((JComponent)mainPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
        KeyStrokes.registerCommand((JComponent)buttonPanel, (Action)cancelAction, (String)"CANCEL_ACTION");
    }

    public void setAdding(boolean adding) {
        this.adding = adding;
        if (adding) {
            this.setTitle("Add condition...");
        } else {
            this.setTitle("Edit condition...");
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.conditionName.requestFocusInWindow();
            this.initUI();
        }
        super.setVisible(b);
    }

    private void updateActions() {
        this.okAction.update();
    }

    public boolean isAdding() {
        return this.adding;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setConditionName(String conditionName) {
        this.conditionName.setText(conditionName);
    }

    public String getConditionName() {
        return this.conditionName.getText();
    }

    public void initUI() {
        this.updateActions();
    }

    private class TextKeyListener
    implements KeyListener {
        private TextKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            EditConditionDialog.this.updateActions();
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class ConditionNameActionListener
    implements ActionListener {
        private ConditionNameActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditConditionDialog.this.okAction.actionPerformed(e);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (EditConditionDialog.this.logger.isDebugEnabled()) {
                EditConditionDialog.this.logger.debug("accelerator: {}", (Object)accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            EditConditionDialog.this.canceled = true;
            EditConditionDialog.this.setVisible(false);
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        public void update() {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            String name = EditConditionDialog.this.conditionName.getText();
            if (name != null && !"".equals(name.trim())) {
                EditConditionDialog.this.canceled = false;
                EditConditionDialog.this.setVisible(false);
            }
        }
    }
}

