/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.linklistener;

import de.huxhorn.lilith.swing.MainFrame;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.swing.BasicPanel;
import org.xhtmlrenderer.swing.LinkListener;

public class OpenUrlLinkListener
extends LinkListener {
    private final Logger logger = LoggerFactory.getLogger(OpenUrlLinkListener.class);
    public static final String STACK_TRACE_ELEMENT_URI_PREFIX = "ste://";
    private MainFrame mainFrame;
    private LinkListener originalLinkListener;

    public OpenUrlLinkListener(MainFrame mainFrame, LinkListener originalLinkListener) {
        this.mainFrame = mainFrame;
        this.originalLinkListener = originalLinkListener;
    }

    public void linkClicked(BasicPanel basicPanel, String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Link clicked: {}", (Object)uri);
        }
        if (uri.contains("://")) {
            try {
                this.mainFrame.openUrl(new URL(uri));
            }
            catch (MalformedURLException e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Couldn't create URL for uri-string " + uri + "!", (Throwable)e);
                }
            }
        } else if (this.originalLinkListener != null) {
            this.originalLinkListener.linkClicked(basicPanel, uri);
        }
    }
}

