/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.debug;

import de.huxhorn.lilith.debug.LoggerEventEmitter;
import de.huxhorn.lilith.swing.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(DebugDialog.class);
    LoggerEventEmitter loggerEventEmitter;
    private MainFrame mainFrame;

    public DebugDialog(Frame owner, MainFrame mainFrame) {
        super(owner, "Debug");
        this.mainFrame = mainFrame;
        this.initUI();
    }

    public DebugDialog(Dialog owner) {
        super(owner, "Debug");
        this.initUI();
    }

    private void initUI() {
        this.setModal(false);
        this.loggerEventEmitter = new LoggerEventEmitter();
        this.loggerEventEmitter.setDelay(0);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(new DoneAction()));
        JToolBar debugToolbar = new JToolBar();
        debugToolbar.setFloatable(false);
        AbstractAction action = new LogStuffAction();
        JButton button = new JButton(action);
        debugToolbar.add(button);
        action = new LogExceptionsAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogParamExceptionsAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogSkullAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogTruthAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogAnonymousAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogAllAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new EditGroovyAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new NetworkAction();
        button = new JButton(action);
        debugToolbar.add(button);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)debugToolbar, "North");
        contentPane.add((Component)buttonPanel, "South");
    }

    private class LogAnonymousAction
    extends AbstractAction {
        public LogAnonymousAction() {
            super("Log anonymous");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logAnonymous();
        }
    }

    private class LogTruthAction
    extends AbstractAction {
        public LogTruthAction() {
            super("Log truth");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logTruth();
        }
    }

    private class LogSkullAction
    extends AbstractAction {
        public LogSkullAction() {
            super("Log skull");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logSkull();
        }
    }

    private class LogParamExceptionsAction
    extends AbstractAction {
        public LogParamExceptionsAction() {
            super("Log param exceptions");
        }

        public void actionPerformed(ActionEvent e) {
            block2: {
                try {
                    DebugDialog.this.loggerEventEmitter.logParamException();
                }
                catch (InterruptedException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block2;
                    DebugDialog.this.logger.warn("Interrupted debug action...", (Throwable)ex);
                }
            }
        }
    }

    private class LogExceptionsAction
    extends AbstractAction {
        public LogExceptionsAction() {
            super("Log exceptions");
        }

        public void actionPerformed(ActionEvent e) {
            block2: {
                try {
                    DebugDialog.this.loggerEventEmitter.logException();
                    DebugDialog.this.loggerEventEmitter.logException2();
                }
                catch (InterruptedException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block2;
                    DebugDialog.this.logger.warn("Interrupted debug action...", (Throwable)ex);
                }
            }
        }
    }

    private class LogStuffAction
    extends AbstractAction {
        public LogStuffAction() {
            super("Log stuff");
        }

        public void actionPerformed(ActionEvent e) {
            block2: {
                try {
                    DebugDialog.this.loggerEventEmitter.logStuff();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
                }
                catch (InterruptedException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block2;
                    DebugDialog.this.logger.warn("Interrupted debug action...", (Throwable)ex);
                }
            }
        }
    }

    private class NetworkAction
    extends AbstractAction {
        public NetworkAction() {
            super("Network");
        }

        public void actionPerformed(ActionEvent e) {
            HashSet<InetAddress> inetAddresses;
            block5: {
                inetAddresses = new HashSet<InetAddress>();
                try {
                    Enumeration<NetworkInterface> netIfcs = NetworkInterface.getNetworkInterfaces();
                    while (netIfcs.hasMoreElements()) {
                        NetworkInterface ni = netIfcs.nextElement();
                        Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                        while (inetAddrs.hasMoreElements()) {
                            InetAddress iadd = inetAddrs.nextElement();
                            if (iadd.isLoopbackAddress()) continue;
                            inetAddresses.add(iadd);
                        }
                    }
                }
                catch (SocketException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block5;
                    DebugDialog.this.logger.warn("Exception while retrieving InetAddresses!", (Throwable)ex);
                }
            }
            if (DebugDialog.this.logger.isInfoEnabled()) {
                DebugDialog.this.logger.info("InetAddresses: {}", inetAddresses);
            }
        }
    }

    private class EditGroovyAction
    extends AbstractAction {
        public EditGroovyAction() {
            super("Edit groovy!");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.mainFrame.getPreferencesDialog().editDetailsFormatter();
        }
    }

    private class LogAllAction
    extends AbstractAction {
        public LogAllAction() {
            super("Log all!");
        }

        public void actionPerformed(ActionEvent e) {
            block2: {
                try {
                    DebugDialog.this.loggerEventEmitter.logStuff();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
                    DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
                    DebugDialog.this.loggerEventEmitter.logException();
                    DebugDialog.this.loggerEventEmitter.logException2();
                    DebugDialog.this.loggerEventEmitter.logParamException();
                    DebugDialog.this.loggerEventEmitter.logSkull();
                    DebugDialog.this.loggerEventEmitter.logTruth();
                    DebugDialog.this.loggerEventEmitter.logAnonymous();
                }
                catch (InterruptedException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block2;
                    DebugDialog.this.logger.warn("Interrupted debug action...", (Throwable)ex);
                }
            }
        }
    }

    private class DoneAction
    extends AbstractAction {
        public DoneAction() {
            super("Done!");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.setVisible(false);
        }
    }
}

