/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.sulky.swing.AbstractProgressingCallable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingCallable
extends AbstractProgressingCallable<Integer> {
    private final Logger logger = LoggerFactory.getLogger(IndexingCallable.class);
    private File logFile;
    private File indexFile;
    private Set<String> threadNames;
    private Set<String> loggerNames;

    public IndexingCallable(File logFile, File indexFile) {
        this.logFile = logFile;
        this.indexFile = indexFile;
        this.threadNames = new TreeSet<String>();
        this.loggerNames = new TreeSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer call() throws Exception {
        BufferedInputStream bis;
        DataOutputStream dataOutputStream;
        int counter;
        block10: {
            if (!this.logFile.exists()) {
                throw new FileNotFoundException("File '" + this.logFile.getAbsolutePath() + "' does not exist!");
            }
            if (!this.logFile.isFile()) {
                throw new FileNotFoundException("File '" + this.logFile.getAbsolutePath() + "' is not a file!");
            }
            long fileSize = this.logFile.length();
            this.setNumberOfSteps(fileSize);
            counter = 0;
            dataOutputStream = null;
            bis = null;
            try {
                Exception error;
                FileOutputStream fos = new FileOutputStream(this.indexFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                dataOutputStream = new DataOutputStream(bos);
                FileInputStream fis = new FileInputStream(this.logFile);
                bis = new BufferedInputStream(fis);
                CountingInputStream byteCounter = new CountingInputStream((InputStream)bis);
                DataInputStream dis = new DataInputStream((InputStream)byteCounter);
                long previousByteCount = 0L;
                do {
                    error = null;
                    try {
                        int bufferSize = dis.readInt();
                        byte[] buffer = new byte[bufferSize];
                        dis.readFully(buffer);
                        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                        GZIPInputStream gis = new GZIPInputStream(bais);
                        ObjectInputStream ois = new ObjectInputStream(gis);
                        Object o = ois.readObject();
                        this.performAdditionalWork(o);
                        dataOutputStream.writeLong(previousByteCount);
                        long byteCount = byteCounter.getByteCount();
                        ++counter;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("counter={}, byteCounter={}, previousByteCount={}", new Object[]{counter, byteCount, previousByteCount});
                        }
                        previousByteCount = byteCount;
                        this.setCurrentStep(byteCount);
                        if (byteCount != fileSize) continue;
                        this.finish();
                        break block10;
                    }
                    catch (IOException e) {
                        error = e;
                    }
                    catch (ClassNotFoundException e) {
                        error = e;
                    }
                } while (error == null);
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error while indexing...", (Throwable)error);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dataOutputStream);
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)dataOutputStream);
        IOUtils.closeQuietly((InputStream)bis);
        return counter;
    }

    private void finish() {
        if (this.logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("threadNames:\n");
            for (String name : this.threadNames) {
                msg.append("\t- ").append(name).append("\n");
            }
            msg.append("\n");
            msg.append("loggerNames:\n");
            for (String name : this.loggerNames) {
                msg.append("\t- ").append(name).append("\n");
            }
            this.logger.debug(msg.toString());
        }
    }

    private void performAdditionalWork(Object o) {
        EventWrapper wrapper;
        Serializable eventObj;
        if (o instanceof EventWrapper && (eventObj = (wrapper = (EventWrapper)o).getEvent()) instanceof LoggingEvent) {
            String threadName;
            LoggingEvent event = (LoggingEvent)eventObj;
            String loggerName = event.getLogger();
            if (!this.loggerNames.contains(loggerName)) {
                this.loggerNames.add(loggerName);
            }
            if (!this.threadNames.contains(threadName = event.getThreadName())) {
                this.threadNames.add(threadName);
            }
        }
    }
}

