/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewManager<T extends Serializable> {
    private final Logger logger = LoggerFactory.getLogger(ViewManager.class);
    private final Map<EventSource<T>, ViewContainer<T>> views;
    private MainFrame mainFrame;

    public ViewManager(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.views = new HashMap<EventSource<T>, ViewContainer<T>>();
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewContainer<T> retrieveViewContainer(EventSource<T> eventSource) {
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            ViewContainer<T> result = this.views.get(eventSource);
            if (result == null) {
                result = this.createViewContainer(eventSource);
                this.views.put(eventSource, result);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Added view for eventSource {}.", eventSource);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EventSource<T>, ViewContainer<T>> getViews() {
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            return new HashMap<EventSource<T>, ViewContainer<T>>(this.views);
        }
    }

    protected abstract ViewContainer<T> createViewContainer(EventSource<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ViewContainer<T>> minimizeAllViews(ViewContainer beside) {
        ArrayList<ViewContainer<T>> result = new ArrayList<ViewContainer<T>>();
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            for (Map.Entry<EventSource<T>, ViewContainer<T>> entry : this.views.entrySet()) {
                ViewContainer<T> value = entry.getValue();
                if (value.resolveViewWindow() == null || value == beside) continue;
                result.add(value);
            }
        }
        for (ViewContainer viewContainer : result) {
            this.minimizeViewContainer(viewContainer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ViewContainer<T>> closeAllViews(ViewContainer beside) {
        ArrayList<ViewContainer<T>> result = new ArrayList<ViewContainer<T>>();
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            ArrayList<EventSource<T>> arrayList = new ArrayList<EventSource<T>>();
            for (Map.Entry<EventSource<T>, ViewContainer<T>> entry : this.views.entrySet()) {
                EventSource<T> key = entry.getKey();
                ViewContainer<T> value = entry.getValue();
                EventWrapperViewPanel<T> panel = value.getDefaultView();
                if (!key.isGlobal() && LoggingViewState.INACTIVE == panel.getState() && value != beside) {
                    arrayList.add(key);
                }
                if (value.resolveViewWindow() == null || value == beside) continue;
                result.add(value);
            }
            for (EventSource eventSource : arrayList) {
                this.removeView(eventSource);
            }
        }
        for (ViewContainer viewContainer : result) {
            this.closeViewContainer(viewContainer);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ViewContainer<T>> removeInactiveViews(boolean onlyClosed) {
        ArrayList<ViewContainer<T>> result = new ArrayList<ViewContainer<T>>();
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            ArrayList<EventSource<T>> arrayList = new ArrayList<EventSource<T>>();
            for (Map.Entry<EventSource<T>, ViewContainer<T>> entry : this.views.entrySet()) {
                EventSource<T> key = entry.getKey();
                ViewContainer<T> value = entry.getValue();
                EventWrapperViewPanel<T> panel = value.getDefaultView();
                if (key.isGlobal() || LoggingViewState.INACTIVE != panel.getState()) continue;
                if (onlyClosed) {
                    if (value.resolveViewWindow() != null) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Removed ");
                    }
                    result.add(value);
                    arrayList.add(key);
                    continue;
                }
                result.add(value);
                arrayList.add(key);
            }
            for (EventSource eventSource : arrayList) {
                this.removeView(eventSource);
            }
        }
        for (ViewContainer viewContainer : result) {
            this.closeViewContainer(viewContainer);
        }
        return result;
    }

    private void minimizeViewContainer(ViewContainer<T> lvc) {
        ViewWindow window = lvc.resolveViewWindow();
        if (window != null) {
            window.minimizeWindow();
        }
    }

    void closeViewContainer(ViewContainer<T> lvc) {
        ViewWindow window = lvc.resolveViewWindow();
        if (window != null) {
            window.closeWindow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeView(EventSource<T> source) {
        ViewContainer<T> previous;
        Map<EventSource<T>, ViewContainer<T>> map = this.views;
        synchronized (map) {
            previous = this.views.remove(source);
        }
        if (previous != null) {
            previous.dispose();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removed view for {}.", source);
            }
        }
    }
}

