/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContainerInternalFrame
extends JInternalFrame
implements ViewWindow {
    private final Logger logger = LoggerFactory.getLogger(ViewContainerInternalFrame.class);
    private MainFrame mainFrame;
    private ViewContainer viewContainer;

    public ViewContainerInternalFrame(MainFrame mainFrame, ViewContainer viewContainer) {
        this.mainFrame = mainFrame;
        this.viewContainer = viewContainer;
        this.setDefaultCloseOperation(2);
        this.add((Component)viewContainer, "Center");
        this.setClosable(true);
        this.setResizable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.addInternalFrameListener(new CleanupWindowChangeListener());
    }

    public void setGlassPane(Component glassPane) {
        Component prev = this.getGlassPane();
        super.setGlassPane(glassPane);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Glasspane\nprev: {}\n new: {}", (Object)prev, (Object)glassPane);
        }
    }

    public ViewActions getViewActions() {
        return this.mainFrame.getViewActions();
    }

    public void focusWindow() {
        block2: {
            try {
                this.setIcon(false);
                this.toFront();
                this.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Veto!!", (Throwable)ex);
            }
        }
    }

    public void minimizeWindow() {
        try {
            this.setIcon(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public void closeWindow() {
        StringBuffer result;
        JInternalFrame[] frames;
        JDesktopPane desktop;
        block10: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing InternalFrame...");
            }
            desktop = this.mainFrame.getDesktop();
            if (this.logger.isDebugEnabled()) {
                frames = desktop.getAllFrames();
                result = new StringBuffer();
                result.append("before closing:\n");
                if (frames != null) {
                    for (JInternalFrame current : frames) {
                        result.append(current).append("\n");
                    }
                }
                this.logger.debug(result.toString());
            }
            this.setVisible(false);
            try {
                this.setClosed(true);
            }
            catch (PropertyVetoException ex) {
                if (!this.logger.isWarnEnabled()) break block10;
                this.logger.warn("Couldn't close InternalFrame!", (Throwable)ex);
            }
        }
        if (this.logger.isDebugEnabled()) {
            frames = desktop.getAllFrames();
            result = new StringBuffer();
            result.append("after closing:\n");
            if (frames != null) {
                for (JInternalFrame current : frames) {
                    result.append(current).append("\n");
                }
            }
            this.logger.debug(result.toString());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closed InternalFrame...");
        }
    }

    class CleanupWindowChangeListener
    implements InternalFrameListener {
        CleanupWindowChangeListener() {
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            if (ViewContainerInternalFrame.this.logger.isDebugEnabled()) {
                ViewContainerInternalFrame.this.logger.debug("internalFrameClosing");
            }
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            if (ViewContainerInternalFrame.this.logger.isDebugEnabled()) {
                ViewContainerInternalFrame.this.logger.debug("internalFrameClosed");
            }
            ViewContainerInternalFrame.this.viewContainer.cancelSearching();
            ViewContainerInternalFrame.this.getContentPane().removeAll();
            ViewContainerInternalFrame.this.mainFrame.updateWindowMenus();
        }

        public void internalFrameOpened(InternalFrameEvent e) {
        }

        public void internalFrameIconified(InternalFrameEvent e) {
        }

        public void internalFrameDeiconified(InternalFrameEvent e) {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            ViewContainerInternalFrame.this.mainFrame.getViewActions().setViewContainer(ViewContainerInternalFrame.this.viewContainer);
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            ViewContainerInternalFrame.this.mainFrame.getViewActions().setViewContainer(null);
        }
    }
}

