/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.Lilith;
import de.huxhorn.lilith.LilithBuffer;
import de.huxhorn.lilith.appender.InternalLilithAppender;
import de.huxhorn.lilith.consumers.AlarmSoundAccessEventConsumer;
import de.huxhorn.lilith.consumers.AlarmSoundLoggingEventConsumer;
import de.huxhorn.lilith.consumers.FileDumpEventConsumer;
import de.huxhorn.lilith.consumers.FileSplitterEventConsumer;
import de.huxhorn.lilith.consumers.RrdLoggingEventConsumer;
import de.huxhorn.lilith.consumers.UserNotificationAccessEventConsumer;
import de.huxhorn.lilith.consumers.UserNotificationLoggingEventConsumer;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.EventSourceListener;
import de.huxhorn.lilith.engine.EventSourceProducer;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.engine.impl.sourcemanager.SourceManagerImpl;
import de.huxhorn.lilith.engine.impl.sourceproducer.SerializingMessageBasedServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlMessageLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.engine.xml.sourceproducer.LilithXmlStreamLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.logback.producer.LogbackAccessServerSocketEventSourceProducer;
import de.huxhorn.lilith.logback.producer.LogbackLoggingServerSocketEventSourceProducer;
import de.huxhorn.lilith.services.gotosrc.GoToSourceService;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.services.sender.SenderService;
import de.huxhorn.lilith.swing.AboutDialog;
import de.huxhorn.lilith.swing.AccessEventViewManager;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.HelpFrame;
import de.huxhorn.lilith.swing.HtmlTransferable;
import de.huxhorn.lilith.swing.LoggingEventViewManager;
import de.huxhorn.lilith.swing.LoggingEventViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.OpenPreviousDialog;
import de.huxhorn.lilith.swing.StatisticsDialog;
import de.huxhorn.lilith.swing.ViewActions;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewContainerFrame;
import de.huxhorn.lilith.swing.ViewContainerInternalFrame;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.debug.DebugDialog;
import de.huxhorn.lilith.swing.filefilters.DirectoryFilter;
import de.huxhorn.lilith.swing.filefilters.LogFileFilter;
import de.huxhorn.lilith.swing.filefilters.RrdFileFilter;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import de.huxhorn.sulky.formatting.SimpleXml;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.swing.MemoryStatus;
import de.huxhorn.sulky.swing.SwingWorkManager;
import de.huxhorn.sulky.swing.Windows;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
    private final File startupApplicationPath;
    private GoToSourceService gotoSource;
    private LogFileFactory loggingFileFactory;
    private SourceManager<LoggingEvent> loggingEventSourceManager;
    private FileBufferFactory<LoggingEvent> loggingFileBufferFactory;
    private EventSourceListener<LoggingEvent> loggingSourceListener;
    private LoggingEventViewManager loggingEventViewManager;
    private LogFileFactory accessFileFactory;
    private SourceManager<AccessEvent> accessEventSourceManager;
    private FileBufferFactory<AccessEvent> accessFileBufferFactory;
    private EventSourceListener<AccessEvent> accessSourceListener;
    private AccessEventViewManager accessEventViewManager;
    private Sounds sounds;
    private JDesktopPane desktop;
    private PreferencesDialog preferencesDialog;
    private JDialog aboutDialog;
    private JLabel statusLabel;
    private ApplicationPreferences applicationPreferences;
    private DebugDialog debugDialog;
    private RrdFileFilter rrdFileFilter;
    private StatisticsDialog statisticsDialog;
    private SwingWorkManager<Integer> integerWorkManager;
    private File groovyFiltersPath;
    private static final String GROOVY_SUFFIX = ".groovy";
    private ViewActions viewActions;
    private OpenPreviousDialog openInactiveLogsDialog;
    private HelpFrame helpFrame;
    private Application application = new DefaultApplication();
    private int activeCounter;
    private List<AutostartRunnable> autostartProcesses;
    private URL helpUrl;
    private SenderService senderService;
    private boolean enableBonjour;
    private final boolean isMac = this.application.isMac();
    private final boolean isWindows;
    private long lastScriptRefresh = 0L;
    private long previousScriptFileTimestamp = 0L;
    private Script detailsViewScript;
    private static final int SCRIPT_REFRESH_INTERVAL = 5000;
    private static final String[] MAC_OPEN_URL_ARRAY = new String[]{"open", null};
    private static final String[] WINDOWS_OPEN_URL_ARRAY = new String[]{"cmd", "/C", "start", null};

    public File resolveScriptFile(String input) {
        File scriptFile;
        if (!input.endsWith(GROOVY_SUFFIX)) {
            input = input + GROOVY_SUFFIX;
        }
        if ((scriptFile = new File(this.groovyFiltersPath, input)).isFile()) {
            return scriptFile;
        }
        return null;
    }

    public PreferencesDialog getPreferencesDialog() {
        return this.preferencesDialog;
    }

    public ViewActions getViewActions() {
        return this.viewActions;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public MainFrame(ApplicationPreferences applicationPreferences, String appName, boolean enableBonjour) {
        super(appName);
        if (!this.isMac) {
            String osName = System.getProperty("os.name").toLowerCase();
            this.isWindows = osName.startsWith("windows");
        } else {
            this.isWindows = false;
        }
        this.autostartProcesses = new ArrayList<AutostartRunnable>();
        this.addWindowListener(new MainWindowListener());
        Runtime runtime = Runtime.getRuntime();
        Thread shutdownHook = new Thread(new ShutdownRunnable());
        runtime.addShutdownHook(shutdownHook);
        this.senderService = new SenderService(this);
        this.enableBonjour = enableBonjour;
        this.integerWorkManager = new SwingWorkManager();
        this.startupApplicationPath = applicationPreferences.getStartupApplicationPath();
        this.loggingFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, "sources/logs"), "ljlogging");
        this.accessFileFactory = new LogFileFactoryImpl(new File(this.startupApplicationPath, "sources/access"), "ljaccess");
        this.loggingFileBufferFactory = new FileBufferFactory(this.loggingFileFactory);
        this.accessFileBufferFactory = new FileBufferFactory(this.accessFileFactory);
        this.rrdFileFilter = new RrdFileFilter();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Before creation of statistics-dialog...");
        }
        this.statisticsDialog = new StatisticsDialog(this);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("After creation of statistics-dialog...");
        }
        this.groovyFiltersPath = new File(this.startupApplicationPath, "filters");
        this.groovyFiltersPath.mkdirs();
        this.loggingEventViewManager = new LoggingEventViewManager(this);
        this.accessEventViewManager = new AccessEventViewManager(this);
        this.applicationPreferences = applicationPreferences;
        applicationPreferences.addPropertyChangeListener(new PreferencesChangeListener());
        this.loggingSourceListener = new LoggingEventSourceListener();
        this.accessSourceListener = new AccessEventSourceListener();
        this.desktop = new JDesktopPane();
        JPanel statusBar = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Starting...");
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 5, 0, 0);
        statusBar.add((Component)this.statusLabel, gbc);
        MemoryStatus memoryStatus = new MemoryStatus();
        memoryStatus.setBackground(Color.WHITE);
        memoryStatus.setOpaque(true);
        memoryStatus.setUsingBinaryUnits(true);
        memoryStatus.setUsingTotal(false);
        memoryStatus.setBorder((Border)new EtchedBorder(1));
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        statusBar.add((Component)memoryStatus, gbc);
        this.add((Component)this.desktop, "Center");
        this.add((Component)statusBar, "South");
        this.aboutDialog = new AboutDialog((Frame)this, "About " + appName + "...", appName);
        this.debugDialog = new DebugDialog((Frame)this, this);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Before creation of preferences-dialog...");
        }
        this.preferencesDialog = new PreferencesDialog(this);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("After creation of preferences-dialog...");
        }
        this.openInactiveLogsDialog = new OpenPreviousDialog(this);
        this.helpFrame = new HelpFrame(this);
        this.helpFrame.setTitle("Help Topics");
        this.helpUrl = MainFrame.class.getResource("/help/index.xhtml");
    }

    public Application getApplication() {
        return this.application;
    }

    public Map<String, EventSender<LoggingEvent>> getLoggingEventSenders() {
        return this.senderService.getLoggingEventSenders();
    }

    public Map<String, EventSender<AccessEvent>> getAccessEventSenders() {
        return this.senderService.getAccessEventSenders();
    }

    public void updateWindowMenus() {
        this.viewActions.updateWindowMenu();
        Map loggingViews = this.loggingEventViewManager.getViews();
        for (Map.Entry current : loggingViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
        Map accessViews = this.accessEventViewManager.getViews();
        for (Map.Entry current : accessViews.entrySet()) {
            ViewContainer value = current.getValue();
            ViewWindow window = value.resolveViewWindow();
            if (!(window instanceof JFrame)) continue;
            window.getViewActions().updateWindowMenu();
        }
    }

    public void closeLoggingConnection(SourceIdentifier id) {
        this.loggingEventSourceManager.removeEventProducer(id);
    }

    public void closeAccessConnection(SourceIdentifier id) {
        this.accessEventSourceManager.removeEventProducer(id);
    }

    public void startUp() {
        FileDumpEventConsumer accessFileDump;
        FileDumpEventConsumer loggingFileDump;
        block35: {
            SerializingMessageBasedServerSocketEventSourceProducer producer;
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            File[] autoFiles;
                                            File autostartDir = new File(this.startupApplicationPath, "autostart");
                                            if (autostartDir.mkdirs() && this.logger.isDebugEnabled()) {
                                                this.logger.debug("Created '{}'.", (Object)autostartDir.getAbsolutePath());
                                            }
                                            if ((autoFiles = autostartDir.listFiles(new FileFilter(){

                                                public boolean accept(File file) {
                                                    return file.isFile();
                                                }
                                            })) != null && autoFiles.length > 0) {
                                                Arrays.sort(autoFiles, new Comparator<File>(){

                                                    @Override
                                                    public int compare(File o1, File o2) {
                                                        return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
                                                    }
                                                });
                                                for (File current : autoFiles) {
                                                    AutostartRunnable r = new AutostartRunnable(current);
                                                    this.autostartProcesses.add(r);
                                                    Thread t = new Thread((Runnable)r, current.getAbsolutePath());
                                                    t.setDaemon(true);
                                                    t.start();
                                                }
                                            } else if (this.logger.isInfoEnabled()) {
                                                this.logger.info("No autostart files defined in '{}'.", (Object)autostartDir.getAbsolutePath());
                                            }
                                            this.gotoSource = new GoToSourceService();
                                            SourceIdentifier globalSourceIdentifier = new SourceIdentifier("global", null);
                                            File globalLoggingDataFile = this.loggingFileFactory.getDataFile(globalSourceIdentifier);
                                            File globalLoggingIndexFile = this.loggingFileFactory.getIndexFile(globalSourceIdentifier);
                                            loggingFileDump = new FileDumpEventConsumer(globalLoggingDataFile, globalLoggingIndexFile);
                                            File globalAccessDataFile = this.accessFileFactory.getDataFile(globalSourceIdentifier);
                                            File globalAccessIndexFile = this.accessFileFactory.getIndexFile(globalSourceIdentifier);
                                            accessFileDump = new FileDumpEventConsumer(globalAccessDataFile, globalAccessIndexFile);
                                            LilithBuffer loggingEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                            LilithBuffer accessEventQueue = new LilithBuffer(this.applicationPreferences, 1000);
                                            SourceManagerImpl lsm = new SourceManagerImpl(loggingEventQueue);
                                            EventSourceImpl globalLoggingEventSource = new EventSourceImpl(globalSourceIdentifier, loggingFileDump.getBuffer(), true);
                                            lsm.addSource((EventSource)globalLoggingEventSource);
                                            EventSourceImpl lilithLoggingEventSource = new EventSourceImpl(InternalLilithAppender.getSourceIdentifier(), InternalLilithAppender.getBuffer(), false);
                                            lsm.addSource((EventSource)lilithLoggingEventSource);
                                            this.setLoggingEventSourceManager((SourceManager<LoggingEvent>)lsm);
                                            SourceManagerImpl asm = new SourceManagerImpl(accessEventQueue);
                                            EventSourceImpl globalAccessEventSource = new EventSourceImpl(globalSourceIdentifier, accessFileDump.getBuffer(), true);
                                            asm.addSource((EventSource)globalAccessEventSource);
                                            this.setAccessEventSourceManager((SourceManager<AccessEvent>)asm);
                                            try {
                                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)new LogbackLoggingServerSocketEventSourceProducer(4560));
                                            }
                                            catch (IOException ex) {
                                                if (!this.logger.isWarnEnabled()) break block27;
                                                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                            }
                                        }
                                        try {
                                            producer = new SerializingMessageBasedServerSocketEventSourceProducer(10000, true);
                                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                            this.senderService.addLoggingProducer((SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent>)producer);
                                        }
                                        catch (IOException ex) {
                                            if (!this.logger.isWarnEnabled()) break block28;
                                            this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                        }
                                    }
                                    try {
                                        producer = new SerializingMessageBasedServerSocketEventSourceProducer(10001, false);
                                        this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                        this.senderService.addLoggingProducer((SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent>)producer);
                                    }
                                    catch (IOException ex) {
                                        if (!this.logger.isWarnEnabled()) break block29;
                                        this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                    }
                                }
                                try {
                                    producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10021, false);
                                    this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                                }
                                catch (IOException ex) {
                                    if (!this.logger.isWarnEnabled()) break block30;
                                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                                }
                            }
                            try {
                                producer = new LilithXmlMessageLoggingServerSocketEventSourceProducer(10020, true);
                                this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                            }
                            catch (IOException ex) {
                                if (!this.logger.isWarnEnabled()) break block31;
                                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                            }
                        }
                        try {
                            producer = new LilithXmlStreamLoggingServerSocketEventSourceProducer(11000);
                            this.loggingEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                        }
                        catch (IOException ex) {
                            if (!this.logger.isWarnEnabled()) break block32;
                            this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                        }
                    }
                    try {
                        this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)new LogbackAccessServerSocketEventSourceProducer(4570));
                    }
                    catch (IOException ex) {
                        if (!this.logger.isWarnEnabled()) break block33;
                        this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                    }
                }
                try {
                    producer = new SerializingMessageBasedServerSocketEventSourceProducer(10010, true);
                    this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                    this.senderService.addAccessProducer((SerializingMessageBasedServerSocketEventSourceProducer<AccessEvent>)producer);
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block34;
                    this.logger.warn("Exception while creating event producer!", (Throwable)ex);
                }
            }
            try {
                producer = new SerializingMessageBasedServerSocketEventSourceProducer(10011, false);
                this.accessEventSourceManager.addEventSourceProducer((EventSourceProducer)producer);
                this.senderService.addAccessProducer((SerializingMessageBasedServerSocketEventSourceProducer<AccessEvent>)producer);
            }
            catch (IOException ex) {
                if (!this.logger.isWarnEnabled()) break block35;
                this.logger.warn("Exception while creating event producer!", (Throwable)ex);
            }
        }
        this.viewActions = new ViewActions(this, null);
        this.viewActions.getPopupMenu();
        RrdLoggingEventConsumer rrdDb = new RrdLoggingEventConsumer();
        rrdDb.setBasePath(new File(this.startupApplicationPath, "statistics"));
        AlarmSoundLoggingEventConsumer loggingEventAlarmSound = new AlarmSoundLoggingEventConsumer();
        loggingEventAlarmSound.setSounds(this.sounds);
        FileSplitterEventConsumer<LoggingEvent> fileSplitterLoggingEventConsumer = new FileSplitterEventConsumer<LoggingEvent>(this.loggingFileBufferFactory, this.loggingEventSourceManager);
        ArrayList<Object> loggingConsumers = new ArrayList<Object>();
        loggingConsumers.add(rrdDb);
        loggingConsumers.add(loggingEventAlarmSound);
        loggingConsumers.add(fileSplitterLoggingEventConsumer);
        loggingConsumers.add(loggingFileDump);
        if (this.application.isMac()) {
            UserNotificationLoggingEventConsumer notification = new UserNotificationLoggingEventConsumer(this.application);
            loggingConsumers.add(notification);
        }
        this.loggingEventSourceManager.setEventConsumers(loggingConsumers);
        this.loggingEventSourceManager.start();
        ArrayList<Object> accessConsumers = new ArrayList<Object>();
        FileSplitterEventConsumer<AccessEvent> fileSplitterAccessEventConsumer = new FileSplitterEventConsumer<AccessEvent>(this.accessFileBufferFactory, this.accessEventSourceManager);
        AlarmSoundAccessEventConsumer accessEventAlarmSound = new AlarmSoundAccessEventConsumer();
        accessEventAlarmSound.setSounds(this.sounds);
        accessConsumers.add(accessEventAlarmSound);
        accessConsumers.add(fileSplitterAccessEventConsumer);
        accessConsumers.add(accessFileDump);
        if (this.application.isMac()) {
            UserNotificationAccessEventConsumer notification = new UserNotificationAccessEventConsumer(this.application);
            accessConsumers.add(notification);
        }
        this.accessEventSourceManager.setEventConsumers(accessConsumers);
        this.accessEventSourceManager.start();
        JMenuBar menuBar = this.viewActions.getMenuBar();
        JToolBar toolbar = this.viewActions.getToolbar();
        this.add((Component)toolbar, "North");
        this.setJMenuBar(menuBar);
        this.viewActions.updateWindowMenu();
        this.application.setEnabledAboutMenu(true);
        this.application.setEnabledPreferencesMenu(true);
        this.application.addApplicationListener((ApplicationListener)new MyApplicationListener());
        if (this.enableBonjour) {
            this.senderService.start();
        }
        if (this.applicationPreferences.isCheckingForUpdate()) {
            this.checkForUpdate(false);
        }
    }

    public void goToSource(StackTraceElement ste) {
        if (this.gotoSource != null) {
            this.gotoSource.goToSource(ste);
        }
    }

    public void setActiveConnectionsCounter(int activeCounter) {
        this.activeCounter = activeCounter;
        this.updateStatus();
    }

    public void copyHtml(String html) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        HtmlTransferable transferableText = new HtmlTransferable(html);
        systemClipboard.setContents(transferableText, null);
    }

    public void checkForUpdate(boolean showAlways) {
        Thread t = new Thread(new CheckForUpdateRunnable(showAlways));
        t.start();
    }

    public void showPopup(Component component, Point p) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Show popup at {}.", (Object)p);
        }
        JPopupMenu popup = this.viewActions.getPopupMenu();
        popup.show(component, p.x, p.y);
    }

    private void setLoggingEventSourceManager(SourceManager<LoggingEvent> loggingEventSourceManager) {
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.removeEventSourceListener(this.loggingSourceListener);
        }
        this.loggingEventSourceManager = loggingEventSourceManager;
        if (this.loggingEventSourceManager != null) {
            this.loggingEventSourceManager.addEventSourceListener(this.loggingSourceListener);
            List sources = this.loggingEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.loggingEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<LoggingEvent> getLoggingEventSourceManager() {
        return this.loggingEventSourceManager;
    }

    private void setAccessEventSourceManager(SourceManager<AccessEvent> accessEventSourceManager) {
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.removeEventSourceListener(this.accessSourceListener);
        }
        this.accessEventSourceManager = accessEventSourceManager;
        if (this.accessEventSourceManager != null) {
            this.accessEventSourceManager.addEventSourceListener(this.accessSourceListener);
            List sources = this.accessEventSourceManager.getSources();
            for (EventSource source : sources) {
                this.accessEventViewManager.retrieveViewContainer(source);
            }
        }
    }

    public SourceManager<AccessEvent> getAccessEventSourceManager() {
        return this.accessEventSourceManager;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public void setSounds(Sounds sounds) {
        if (sounds != null) {
            sounds.setSoundLocations(this.applicationPreferences.getSoundLocations());
            sounds.setMute(this.applicationPreferences.isMute());
        }
        this.sounds = sounds;
    }

    private ViewContainer<LoggingEvent> retrieveLoggingViewContainer(EventSource<LoggingEvent> eventSource) {
        return this.loggingEventViewManager.retrieveViewContainer(eventSource);
    }

    private ViewContainer<AccessEvent> retrieveAccessViewContainer(EventSource<AccessEvent> eventSource) {
        return this.accessEventViewManager.retrieveViewContainer(eventSource);
    }

    public ApplicationPreferences getApplicationPreferences() {
        return this.applicationPreferences;
    }

    public EventWrapperViewPanel<LoggingEvent> createLoggingViewPanel(EventSource<LoggingEvent> eventSource) {
        LoggingEventViewPanel result = new LoggingEventViewPanel(this, eventSource);
        result.setScrollingToBottom(this.applicationPreferences.isScrollingToBottom());
        return result;
    }

    public SortedMap<String, SourceIdentifier> getAvailableStatistics() {
        File statisticsPath = new File(this.applicationPreferences.getStartupApplicationPath(), "statistics");
        File[] files = statisticsPath.listFiles(this.rrdFileFilter);
        TreeMap<String, SourceIdentifier> sources = new TreeMap<String, SourceIdentifier>();
        if (files != null) {
            for (File f : files) {
                String name = f.getName();
                if ((name = name.substring(0, name.length() - 4)).equalsIgnoreCase("global")) continue;
                SourceIdentifier si = new SourceIdentifier(name);
                sources.put(this.getSourceTitle(si), si);
            }
        }
        return sources;
    }

    public void showStatistics(SourceIdentifier sourceIdentifier) {
        this.statisticsDialog.setSourceIdentifier(sourceIdentifier);
        Windows.showWindow((Window)this.statisticsDialog, (Window)this, (boolean)true);
    }

    public SwingWorkManager<Integer> getIntegerWorkManager() {
        return this.integerWorkManager;
    }

    public LogFileFactory getAccessFileFactory() {
        return this.accessFileFactory;
    }

    public LogFileFactory getLoggingFileFactory() {
        return this.loggingFileFactory;
    }

    public void showLoggingView(EventSource<LoggingEvent> eventSource) {
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer(eventSource);
        ShowLoggingViewRunnable<LoggingEvent> runnable = new ShowLoggingViewRunnable<LoggingEvent>(container);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void showAccessView(EventSource<AccessEvent> eventSource) {
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer(eventSource);
        ShowLoggingViewRunnable<AccessEvent> runnable = new ShowLoggingViewRunnable<AccessEvent>(container);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void openPreviousLogging(SourceIdentifier si) {
        FileBuffer buffer = this.loggingFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<LoggingEvent> container = this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)eventSource);
        EventWrapperViewPanel<LoggingEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showLoggingView((EventSource<LoggingEvent>)eventSource);
    }

    public void openPreviousAccess(SourceIdentifier si) {
        FileBuffer buffer = this.accessFileBufferFactory.createBuffer(si);
        EventSourceImpl eventSource = new EventSourceImpl(si, (Buffer)buffer, false);
        ViewContainer<AccessEvent> container = this.retrieveAccessViewContainer((EventSource<AccessEvent>)eventSource);
        EventWrapperViewPanel<AccessEvent> panel = container.getDefaultView();
        panel.setState(LoggingViewState.INACTIVE);
        this.showAccessView((EventSource<AccessEvent>)eventSource);
    }

    public void updateStatus() {
        StringBuffer statusText = new StringBuffer();
        ApplicationPreferences.SourceFiltering filtering = this.applicationPreferences.getSourceFiltering();
        switch (filtering) {
            case BLACKLIST: {
                statusText.append("Blacklisting on '");
                statusText.append(this.applicationPreferences.getBlackListName());
                statusText.append("'.  ");
                break;
            }
            case WHITELIST: {
                statusText.append("Whitelisting on '");
                statusText.append(this.applicationPreferences.getWhiteListName());
                statusText.append("'.  ");
            }
        }
        if (this.activeCounter == 0) {
            statusText.append("No active connections.");
        } else if (this.activeCounter == 1) {
            statusText.append("One active connection.");
        } else if (this.activeCounter > 1) {
            statusText.append(this.activeCounter).append(" active connections.");
        }
        this.statusLabel.setText(statusText.toString());
    }

    private void initDetailsViewScript() {
        long current = System.currentTimeMillis();
        if (this.detailsViewScript != null && current - this.lastScriptRefresh < 5000L) {
            return;
        }
        this.lastScriptRefresh = current;
        File detailsViewRoot = this.getApplicationPreferences().getDetailsViewRoot();
        File scriptFile = new File(detailsViewRoot, "detailsView.groovy");
        long scriptFileTimestamp = scriptFile.lastModified();
        if (this.detailsViewScript == null || this.previousScriptFileTimestamp != scriptFileTimestamp) {
            if (!scriptFile.isFile() && this.logger.isWarnEnabled()) {
                this.logger.warn("Scriptfile '{}' is not a file!", (Object)scriptFile.getAbsolutePath());
            }
            GroovyClassLoader gcl = new GroovyClassLoader();
            gcl.setShouldRecompile(Boolean.valueOf(true));
            try {
                Class clazz = gcl.parseClass(scriptFile);
                Object instance = clazz.newInstance();
                if (instance instanceof Script) {
                    this.detailsViewScript = (Script)instance;
                    this.previousScriptFileTimestamp = scriptFileTimestamp;
                }
            }
            catch (Throwable e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while instanciating groovy condition '" + scriptFile.getAbsolutePath() + "'!", e);
                }
                this.detailsViewScript = null;
            }
        }
    }

    public String createMessage(EventWrapper wrapper) {
        String message;
        block7: {
            this.initDetailsViewScript();
            message = "<html><body></body></html>";
            if (wrapper != null) {
                if (this.detailsViewScript == null) {
                    message = "<html><body>detailsView Script is broken!</body></html>";
                } else {
                    try {
                        Binding binding = new Binding();
                        binding.setVariable("eventWrapper", (Object)wrapper);
                        binding.setVariable("logger", (Object)this.logger);
                        this.detailsViewScript.setBinding(binding);
                        Object result = this.detailsViewScript.run();
                        if (result instanceof String) {
                            message = (String)result;
                        }
                    }
                    catch (Throwable t) {
                        message = "<html><body>Exception while executing detailsView Script!</body></html>";
                        if (!this.logger.isWarnEnabled()) break block7;
                        this.logger.warn("Exception while executing detailsView Script!", t);
                    }
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Message:\n{}", (Object)message);
        }
        message = SimpleXml.replaceNonValidXMLCharacters((String)message, (char)' ');
        return message;
    }

    public SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> getSortedLoggingViews() {
        EventSourceComparator loggingComparator = new EventSourceComparator();
        TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> sortedLoggingViews = new TreeMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>>(loggingComparator);
        sortedLoggingViews.putAll(this.loggingEventViewManager.getViews());
        return sortedLoggingViews;
    }

    public SortedMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> getSortedAccessViews() {
        EventSourceComparator accessComparator = new EventSourceComparator();
        TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> sortedAccessViews = new TreeMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>>(accessComparator);
        sortedAccessViews.putAll(this.accessEventViewManager.getViews());
        return sortedAccessViews;
    }

    public void closeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.closeAllViews(beside);
        this.accessEventViewManager.closeAllViews(beside);
    }

    public void minimizeAllViews(ViewContainer beside) {
        this.loggingEventViewManager.minimizeAllViews(beside);
        this.accessEventViewManager.minimizeAllViews(beside);
    }

    public void removeInactiveViews(boolean onlyClosed, boolean clean) {
        EventWrapperViewPanel panel;
        List removed = this.loggingEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
        removed = this.accessEventViewManager.removeInactiveViews(onlyClosed);
        if (clean) {
            for (ViewContainer current : removed) {
                panel = current.getDefaultView();
                panel.clear();
            }
        }
    }

    public void openInactiveLogs() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Open inactive log...");
        }
        Windows.showWindow((Window)this.openInactiveLogsDialog, (Window)this, (boolean)true);
    }

    public void showDebugDialog() {
        Windows.showWindow((Window)this.debugDialog, (Window)this, (boolean)true);
    }

    public void showPreferencesDialog() {
        Windows.showWindow((Window)this.preferencesDialog, (Window)this, (boolean)true);
    }

    public void showHelp() {
        if (this.helpUrl != null) {
            this.helpFrame.setHelpUrl(this.helpUrl);
        }
        Windows.showWindow((Window)this.helpFrame, (Window)this, (boolean)false);
    }

    public void showAboutDialog() {
        Windows.showWindow((Window)this.aboutDialog, (Window)this, (boolean)true);
        if (this.applicationPreferences.isMute() || this.sounds != null) {
            // empty if block
        }
    }

    public void cleanAllInactiveLogs() {
        this.loggingEventViewManager.removeInactiveViews(false);
        this.accessEventViewManager.removeInactiveViews(false);
        this.deleteInactiveLogs(this.loggingFileFactory);
        this.deleteInactiveLogs(this.accessFileFactory);
        this.updateWindowMenus();
    }

    public String getPrimarySourceTitle(String primary) {
        if (primary == null) {
            return null;
        }
        Map<String, String> sourceNames = this.applicationPreferences.getSourceNames();
        String resolvedName = sourceNames.get(primary);
        if (resolvedName != null && !resolvedName.equals(primary)) {
            if (this.applicationPreferences.isShowingIdentifier()) {
                return resolvedName + " [" + primary + "]";
            }
            return resolvedName;
        }
        return primary;
    }

    public String getPrimarySourceTitle(SourceIdentifier identifier) {
        return this.getPrimarySourceTitle(identifier.getIdentifier());
    }

    public String getSourceTitle(SourceIdentifier identifier) {
        String primary = this.getPrimarySourceTitle(identifier);
        String secondary = identifier.getSecondaryIdentifier();
        if (secondary == null) {
            return primary;
        }
        return primary + " - " + secondary;
    }

    public String getLoggingSourceTitle(SourceIdentifier identifier) {
        return this.getSourceTitle(identifier) + " (Logging)";
    }

    public String getAccessSourceTitle(SourceIdentifier identifier) {
        return this.getSourceTitle(identifier) + " (Access)";
    }

    String resolveSourceTitle(ViewContainer container) {
        EventSource eventSource = container.getDefaultView().getEventSource();
        SourceIdentifier si = eventSource.getSourceIdentifier();
        Class clazz = container.getWrappedClass();
        String title = clazz == LoggingEvent.class ? this.getLoggingSourceTitle(si) : this.getAccessSourceTitle(si);
        return title;
    }

    public void openUrl(URL url) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opening URL {}. ", (Object)url);
        }
        Runtime runtime = Runtime.getRuntime();
        String[] cmdArray = this.getOpenUrlCommandArray(url);
        if (cmdArray != null) {
            try {
                Process process = runtime.exec(cmdArray);
                ProcessConsumerRunnable consumer = new ProcessConsumerRunnable(process);
                Thread t = new Thread((Runnable)consumer, "Open URL: " + url);
                t.setDaemon(true);
                t.start();
            }
            catch (IOException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Exception while trying to open URL " + url + "!", (Throwable)e);
                }
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Can't open url {} because no command is defined for the current system.", (Object)url);
        }
    }

    private String[] getOpenUrlCommandArray(URL url) {
        String[] result = null;
        if (this.isWindows) {
            result = new String[WINDOWS_OPEN_URL_ARRAY.length];
            System.arraycopy(WINDOWS_OPEN_URL_ARRAY, 0, result, 0, WINDOWS_OPEN_URL_ARRAY.length);
        } else if (this.isMac) {
            result = new String[MAC_OPEN_URL_ARRAY.length];
            System.arraycopy(MAC_OPEN_URL_ARRAY, 0, result, 0, MAC_OPEN_URL_ARRAY.length);
        }
        if (result != null) {
            String urlStr = url.toString();
            for (int i = 0; i < result.length; ++i) {
                if (result[i] != null) continue;
                result[i] = urlStr;
            }
        }
        return result;
    }

    void showFrame(ViewContainer container) {
        String title = this.resolveSourceTitle(container);
        ViewContainerFrame frame = new ViewContainerFrame(this, container);
        frame.setTitle(title);
        frame.setSize(800, 600);
        Windows.showWindow((Window)frame, null, (boolean)false);
    }

    void showInternalFrame(ViewContainer container) {
        String title = this.resolveSourceTitle(container);
        ViewContainerInternalFrame frame = new ViewContainerInternalFrame(this, container);
        frame.setTitle(title);
        int count = this.desktop.getComponentCount();
        int titleBarHeight = this.resolveInternalTitlebarHeight();
        frame.setBounds(titleBarHeight * (count % 10), titleBarHeight * (count % 10), 640, 480);
        this.desktop.add(frame);
        frame.setVisible(true);
    }

    private int resolveInternalTitlebarHeight() {
        int result = 24;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Height of titlebar: {}", (Object)result);
        }
        return result;
    }

    private void showApplicationPathChangedDialog() {
        int result;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("showApplicationPathChangedDialog()");
        }
        Object[] options = new Object[]{"Exit", "Cancel"};
        ImageIcon icon = null;
        URL url = MainFrame.class.getResource("/tango/32x32/status/dialog-warning.png");
        if (url != null) {
            icon = new ImageIcon(url);
        }
        if ((result = JOptionPane.showOptionDialog(this, "You have changed the application path.\nYou need to restart for this change to take effect.\n\nExit now?", "Exit now?", -1, 2, icon, options, options[0])) == 0) {
            this.exit();
        }
    }

    public void exit() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Exiting...");
        }
        if (this.senderService != null) {
            this.senderService.stop();
        }
        System.exit(0);
    }

    public void deleteInactiveLogs(LogFileFactory fileFactory) {
        List<SourceIdentifier> inactives = this.collectInactiveLogs(fileFactory);
        for (SourceIdentifier si : inactives) {
            File dataFile = fileFactory.getDataFile(si);
            File indexFile = fileFactory.getIndexFile(si);
            dataFile.delete();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Deleted {}", (Object)dataFile);
            }
            indexFile.delete();
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Deleted {}", (Object)indexFile);
        }
    }

    public List<SourceIdentifier> collectInactiveLogs(LogFileFactory fileFactory) {
        ArrayList<SourceIdentifier> result = new ArrayList<SourceIdentifier>();
        File logsRoot = fileFactory.getBaseDir();
        File[] sources = logsRoot.listFiles(new DirectoryFilter());
        if (sources != null) {
            for (File f : sources) {
                this.collectInactiveLogs(fileFactory, f, result);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Inactive logs: {}", result);
            }
        }
        return result;
    }

    private void collectInactiveLogs(LogFileFactory fileFactory, File sourceDir, List<SourceIdentifier> inactiveLogs) {
        String primary = sourceDir.getName();
        File[] logs = sourceDir.listFiles(new LogFileFilter(fileFactory));
        String extension = fileFactory.getDataFileExtension();
        for (File f : logs) {
            String abs = f.getAbsolutePath();
            File active = new File((abs = abs.substring(0, abs.length() - extension.length())) + ".active");
            if (active.isFile()) continue;
            String secondary = f.getName();
            secondary = secondary.substring(0, secondary.length() - extension.length());
            inactiveLogs.add(new SourceIdentifier(primary, secondary));
        }
    }

    public void copyText(String text) {
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferableText = new StringSelection(text);
        systemClipboard.setContents(transferableText, null);
    }

    private void showUpdateDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Check for update...", 1);
    }

    private class ShowUpdateDialog
    implements Runnable {
        private String message;

        public ShowUpdateDialog(String message) {
            this.message = message;
        }

        public void run() {
            MainFrame.this.showUpdateDialog(this.message);
        }
    }

    private class CheckForUpdateRunnable
    implements Runnable {
        private boolean showAlways;

        public CheckForUpdateRunnable(boolean showAlways) {
            this.showAlways = showAlways;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String message;
            String url = "http://lilith.huxhorn.de/current-version.txt";
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod("http://lilith.huxhorn.de/current-version.txt");
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            String currentVersion = null;
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    System.err.println("Method failed: " + method.getStatusLine());
                }
                byte[] responseBody = method.getResponseBody();
                String charSet = method.getResponseCharSet();
                currentVersion = new String(responseBody, charSet);
            }
            catch (Throwable e) {
                if (MainFrame.this.logger.isInfoEnabled()) {
                    MainFrame.this.logger.info("Exception while checking current version!", e);
                }
            }
            finally {
                method.releaseConnection();
            }
            boolean newVersion = false;
            if (currentVersion == null) {
                message = "Couldn't retrieve current version!";
            } else if (!(currentVersion = currentVersion.trim()).equals(Lilith.APP_VERSION)) {
                message = "New version is available: " + currentVersion;
                newVersion = true;
            } else {
                message = "Your version is up to date.";
            }
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Message: {}, newVersion: {}", (Object)message, (Object)newVersion);
            }
            if (newVersion || this.showAlways) {
                SwingUtilities.invokeLater(new ShowUpdateDialog(message));
            }
        }
    }

    public static class ProcessConsumerRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private Process process;

        public ProcessConsumerRunnable(Process process) {
            this.process = process;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block3: {
                try {
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Execution finished with exitCode {}.", (Object)exitCode);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug("Execution of openUrl process was interrupted.", (Throwable)e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println("openUrl: " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (ProcessConsumerRunnable.this.logger.isDebugEnabled()) {
                    ProcessConsumerRunnable.this.logger.debug("{}", (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!ProcessConsumerRunnable.this.logger.isDebugEnabled()) break block3;
                        ProcessConsumerRunnable.this.logger.debug("Exception while reading from openUrl process.", (Throwable)e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    public static class AutostartRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(MainFrame.class);
        private File file;
        private Process process;

        public AutostartRunnable(File file) {
            this.file = file;
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        public void run() {
            block6: {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Starting '{}'.", (Object)this.file.getAbsolutePath());
                    }
                    this.process = Runtime.getRuntime().exec(this.file.getAbsolutePath());
                    Thread errThread = new Thread(new ErrorConsumerRunnable(this.process.getErrorStream()));
                    errThread.setDaemon(true);
                    errThread.start();
                    Thread outThread = new Thread(new OutConsumerRunnable(this.process.getInputStream()));
                    outThread.setDaemon(true);
                    outThread.start();
                    int exitCode = this.process.waitFor();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Execution of '{}' finished with exitCode {}.", (Object)this.file.getAbsolutePath(), (Object)exitCode);
                    }
                }
                catch (IOException e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("Exception while executing '" + this.file.getAbsolutePath() + "'!", (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("Execution of '" + this.file.getAbsolutePath() + "' was interrupted.", (Throwable)e);
                }
            }
        }

        private class ErrorConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public ErrorConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                System.err.println(AutostartRunnable.this.file.getAbsolutePath() + ": " + line);
            }
        }

        private class OutConsumerRunnable
        extends AbstractOutputConsumerRunnable {
            public OutConsumerRunnable(InputStream input) {
                super(input);
            }

            public void processLine(String line) {
                if (AutostartRunnable.this.logger.isDebugEnabled()) {
                    AutostartRunnable.this.logger.debug("{}: {}", (Object)AutostartRunnable.this.file.getAbsolutePath(), (Object)line);
                }
            }
        }

        abstract class AbstractOutputConsumerRunnable
        implements Runnable {
            private BufferedReader inputReader;

            public AbstractOutputConsumerRunnable(InputStream input) {
                this.inputReader = new BufferedReader(new InputStreamReader(input));
            }

            public void run() {
                block3: {
                    try {
                        String line;
                        while ((line = this.inputReader.readLine()) != null) {
                            this.processLine(line);
                        }
                    }
                    catch (IOException e) {
                        if (!AutostartRunnable.this.logger.isDebugEnabled()) break block3;
                        AutostartRunnable.this.logger.debug("Exception while reading from process '" + AutostartRunnable.this.file.getAbsolutePath() + "'.", (Throwable)e);
                    }
                }
            }

            public abstract void processLine(String var1);
        }
    }

    private class ShutdownRunnable
    implements Runnable {
        private ShutdownRunnable() {
        }

        public void run() {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Executing shutdown hook...");
            }
            if (MainFrame.this.gotoSource != null) {
                MainFrame.this.gotoSource.stop();
                MainFrame.this.gotoSource = null;
            }
            for (AutostartRunnable current : MainFrame.this.autostartProcesses) {
                current.destroyProcess();
            }
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Finished executing shutdown hook...");
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            MainFrame.this.exit();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EventSourceComparator<T extends Serializable>
    implements Comparator<EventSource<T>> {
        @Override
        public int compare(EventSource<T> o1, EventSource<T> o2) {
            int compare;
            SourceIdentifier si2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            SourceIdentifier si1 = o1.getSourceIdentifier();
            if (si1 == (si2 = o2.getSourceIdentifier())) {
                return 0;
            }
            if (si1 == null) {
                return -1;
            }
            if (si2 == null) {
                return 1;
            }
            String primary1 = MainFrame.this.getPrimarySourceTitle(si1);
            String primary2 = MainFrame.this.getPrimarySourceTitle(si2);
            if (primary1 != null && primary2 != null && (compare = primary1.compareTo(primary2)) != 0) {
                return compare;
            }
            return o1.compareTo(o2);
        }
    }

    private class PreferencesChangeListener
    implements PropertyChangeListener {
        private PreferencesChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            block9: {
                String propName;
                block12: {
                    block11: {
                        block10: {
                            block8: {
                                propName = evt.getPropertyName();
                                if (!"soundLocations".equals(propName)) break block8;
                                if (MainFrame.this.sounds != null) {
                                    MainFrame.this.sounds.setSoundLocations((Map)evt.getNewValue());
                                }
                                break block9;
                            }
                            if (!"sourceNames".equals(propName) && !"showingIdentifier".equals(propName)) break block10;
                            this.updateSourceTitles();
                            break block9;
                        }
                        if (!"sourceFiltering".equals(propName)) break block11;
                        MainFrame.this.updateStatus();
                        break block9;
                    }
                    if (!"mute".equals(propName)) break block12;
                    if (MainFrame.this.sounds != null) {
                        MainFrame.this.sounds.setMute(((Boolean)evt.getNewValue()).booleanValue());
                    }
                    break block9;
                }
                if (!"applicationPath".equals(propName)) break block9;
                File newPath = (File)evt.getNewValue();
                File oldPath = MainFrame.this.applicationPreferences.getStartupApplicationPath();
                if (oldPath != null) {
                    File previousApplicationPathFile = new File(newPath, ".previous.application.path");
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(previousApplicationPathFile);
                        writer.append(oldPath.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        block7: {
                            try {
                                if (!MainFrame.this.logger.isWarnEnabled()) break block7;
                                MainFrame.this.logger.warn("Exception while writing previous application path to file '" + previousApplicationPathFile.getAbsolutePath() + "'!", (Throwable)ex);
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(writer);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Writer)writer);
                    }
                    IOUtils.closeQuietly((Writer)writer);
                }
                MainFrame.this.showApplicationPathChangedDialog();
            }
        }

        private void updateSourceTitles() {
            MainFrame.this.updateWindowMenus();
            Map loggingViews = MainFrame.this.loggingEventViewManager.getViews();
            for (Map.Entry current : loggingViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
            Map accessViews = MainFrame.this.accessEventViewManager.getViews();
            for (Map.Entry current : accessViews.entrySet()) {
                ViewContainer value = current.getValue();
                ViewWindow window = value.resolveViewWindow();
                if (window == null) continue;
                String title = MainFrame.this.resolveSourceTitle(value);
                window.setTitle(title);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowLoggingViewRunnable<T extends Serializable>
    implements Runnable {
        private ViewContainer<T> container;

        public ShowLoggingViewRunnable(ViewContainer<T> container) {
            this.container = container;
        }

        @Override
        public void run() {
            boolean isNew = false;
            boolean isInternal = false;
            if (this.container.getParent() == null) {
                isNew = true;
                if (!MainFrame.this.applicationPreferences.isUsingInternalFrames()) {
                    MainFrame.this.showFrame(this.container);
                } else {
                    MainFrame.this.showInternalFrame(this.container);
                }
            }
            MainFrame.this.updateWindowMenus();
            ViewWindow window = this.container.resolveViewWindow();
            if (window instanceof ViewContainerInternalFrame) {
                isInternal = true;
            }
            if (isNew) {
                if (MainFrame.this.applicationPreferences.isAutoFocusingWindow()) {
                    window.focusWindow();
                    if (isInternal) {
                        if ((MainFrame.this.getState() & 1) != 0) {
                            MainFrame.this.setState(0);
                        }
                        MainFrame.this.toFront();
                    }
                }
            } else {
                window.focusWindow();
                if (isInternal) {
                    MainFrame.this.toFront();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AccessEventSourceListener
    implements EventSourceListener<AccessEvent> {
        AccessEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<AccessEvent> eventSource) {
            SwingUtilities.invokeLater(new AccessSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceRemovedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceRemovedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.accessEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.accessEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class AccessSourceAddedRunnable
        implements Runnable {
            EventSource<AccessEvent> eventSource;

            public AccessSourceAddedRunnable(EventSource<AccessEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveAccessViewContainer((EventSource<AccessEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showAccessView(this.eventSource);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoggingEventSourceListener
    implements EventSourceListener<LoggingEvent> {
        LoggingEventSourceListener() {
        }

        public void eventSourceAdded(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceAddedRunnable(eventSource));
        }

        public void eventSourceRemoved(EventSource<LoggingEvent> eventSource) {
            SwingUtilities.invokeLater(new LoggingSourceRemovedRunnable(eventSource));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceRemovedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceRemovedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.INACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceRemoved");
                }
                if (MainFrame.this.applicationPreferences.isAutoClosing()) {
                    MainFrame.this.loggingEventViewManager.closeViewContainer(container);
                }
                MainFrame.this.loggingEventSourceManager.removeEventProducer(this.eventSource.getSourceIdentifier());
                MainFrame.this.updateWindowMenus();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class LoggingSourceAddedRunnable
        implements Runnable {
            EventSource<LoggingEvent> eventSource;

            public LoggingSourceAddedRunnable(EventSource<LoggingEvent> eventSource) {
                this.eventSource = eventSource;
            }

            @Override
            public void run() {
                ViewContainer container = MainFrame.this.retrieveLoggingViewContainer((EventSource<LoggingEvent>)this.eventSource);
                EventWrapperViewPanel panel = container.getDefaultView();
                panel.setState(LoggingViewState.ACTIVE);
                if (!MainFrame.this.applicationPreferences.isMute() && MainFrame.this.sounds != null) {
                    MainFrame.this.sounds.play("sourceAdded");
                }
                String primary = this.eventSource.getSourceIdentifier().getIdentifier();
                Map<String, String> sourceNames = MainFrame.this.applicationPreferences.getSourceNames();
                if (!sourceNames.containsKey(primary)) {
                    sourceNames = new HashMap<String, String>(sourceNames);
                    sourceNames.put(primary, primary);
                    MainFrame.this.applicationPreferences.setSourceNames(sourceNames);
                }
                if (MainFrame.this.applicationPreferences.isAutoOpening()) {
                    MainFrame.this.showLoggingView(this.eventSource);
                }
            }
        }
    }

    public class MyApplicationListener
    implements ApplicationListener {
        public void handleAbout(ApplicationEvent event) {
            MainFrame.this.application.requestUserAttention(2);
            MainFrame.this.viewActions.getAboutAction().actionPerformed(null);
            event.setHandled(true);
        }

        public void handleOpenApplication(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Open Application: {}", (Object)applicationEvent);
            }
        }

        public void handleOpenFile(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Open File: {}", (Object)applicationEvent);
            }
        }

        public void handlePreferences(ApplicationEvent applicationEvent) {
            MainFrame.this.viewActions.getPreferencesAction().actionPerformed(null);
        }

        public void handlePrintFile(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Print: {}", (Object)applicationEvent);
            }
        }

        public void handleQuit(ApplicationEvent applicationEvent) {
            MainFrame.this.exit();
        }

        public void handleReopenApplication(ApplicationEvent applicationEvent) {
            if (MainFrame.this.logger.isInfoEnabled()) {
                MainFrame.this.logger.info("Reopen Application: {}", (Object)applicationEvent);
            }
            MainFrame.this.setVisible(true);
        }
    }
}

