/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseAgreementDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(LicenseAgreementDialog.class);
    private AcceptAction acceptAction;
    private DeclineAction declineAction;
    private boolean licenseAgreed;

    public LicenseAgreementDialog() {
        super((Frame)null, "\u00a7\u00a7\u00a7 EULA \u00a7\u00a7\u00a7", true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                LicenseAgreementDialog.this.decline();
            }
        });
        this.licenseAgreed = false;
        this.initUI();
    }

    private void initUI() {
        String licenseText;
        HTMLEditorKit htmlEditorKit;
        JTextPane licenseTextPane;
        JPanel buttonPanel;
        JPanel content;
        block5: {
            content = new JPanel();
            content.setLayout(new BorderLayout());
            buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            licenseTextPane = new JTextPane();
            htmlEditorKit = new HTMLEditorKit();
            licenseText = null;
            InputStream licenseStream = LicenseAgreementDialog.class.getResourceAsStream("/licenses/license.html");
            if (licenseStream != null) {
                try {
                    licenseText = IOUtils.toString((InputStream)licenseStream);
                }
                catch (IOException e) {
                    if (!this.logger.isErrorEnabled()) break block5;
                    this.logger.error("Exception while loading license!", (Throwable)e);
                }
            }
        }
        if (licenseText == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Couldn't find license text! Exiting!");
            }
            System.exit(-1);
        }
        licenseTextPane.setEditorKit(htmlEditorKit);
        licenseTextPane.setEditable(false);
        licenseTextPane.setText(licenseText);
        JScrollPane licenseScrollPane = new JScrollPane(licenseTextPane);
        licenseScrollPane.setPreferredSize(new Dimension(640, 480));
        content.add((Component)licenseScrollPane, "Center");
        content.add((Component)buttonPanel, "South");
        this.acceptAction = new AcceptAction();
        this.declineAction = new DeclineAction();
        JButton acceptButton = new JButton(this.acceptAction);
        JButton declineButton = new JButton(this.declineAction);
        buttonPanel.add(acceptButton);
        buttonPanel.add(declineButton);
        this.setContentPane(content);
        licenseTextPane.setCaretPosition(0);
        declineButton.requestFocusInWindow();
    }

    public boolean isLicenseAgreed() {
        return this.licenseAgreed;
    }

    public void setLicenseAgreed(boolean licenseAgreed) {
        this.licenseAgreed = licenseAgreed;
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    private void accept() {
        this.setLicenseAgreed(true);
    }

    private void decline() {
        this.setLicenseAgreed(false);
    }

    private class DeclineAction
    extends AbstractAction {
        public DeclineAction() {
            super("Decline");
        }

        public void actionPerformed(ActionEvent e) {
            LicenseAgreementDialog.this.decline();
        }
    }

    private class AcceptAction
    extends AbstractAction {
        public AcceptAction() {
            super("Accept");
        }

        public void actionPerformed(ActionEvent e) {
            LicenseAgreementDialog.this.accept();
        }
    }
}

