/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.linklistener.OpenUrlLinkListener;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;

public class HelpFrame
extends JFrame {
    private final Logger logger = LoggerFactory.getLogger(HelpFrame.class);
    private XHTMLPanel helpPane;
    private XhtmlNamespaceHandler xhtmlNamespaceHandler;
    private MainFrame mainFrame;

    public HelpFrame(MainFrame mainFrame) throws HeadlessException {
        this.mainFrame = mainFrame;
        this.setDefaultCloseOperation(1);
        this.initUI();
    }

    private void initUI() {
        this.helpPane = new XHTMLPanel();
        LinkListener originalLinkListener = null;
        List mouseTrackingList = this.helpPane.getMouseTrackingListeners();
        if (mouseTrackingList != null) {
            for (Object o : mouseTrackingList) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Before MTL {}", o);
                }
                if (!(o instanceof LinkListener)) continue;
                this.helpPane.removeMouseTrackingListener((FSMouseListener)((LinkListener)o));
                originalLinkListener = (LinkListener)o;
            }
        }
        this.helpPane.addMouseTrackingListener((FSMouseListener)new OpenUrlLinkListener(this.mainFrame, originalLinkListener));
        this.xhtmlNamespaceHandler = new XhtmlNamespaceHandler();
        FSScrollPane helpScrollPane = new FSScrollPane((JPanel)this.helpPane);
        this.setContentPane((Container)helpScrollPane);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxBounds = ge.getMaximumWindowBounds();
        this.setSize(maxBounds.width / 2, maxBounds.height / 2);
        URL url = HelpFrame.class.getResource("/tango/16x16/apps/help-browser.png");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            this.setIconImage(icon.getImage());
        }
    }

    public void setHelpUrl(URL helpUrl) {
        this.helpPane.setDocument(helpUrl.toExternalForm(), (NamespaceHandler)this.xhtmlNamespaceHandler);
    }
}

