/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.Colors;
import de.huxhorn.lilith.swing.ColorsProvider;
import de.huxhorn.lilith.swing.EventWrapperTableModelBase;
import de.huxhorn.lilith.swing.TooltipGenerator;
import de.huxhorn.sulky.conditions.Condition;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventWrapperViewTable<T extends Serializable>
extends JTable
implements ColorsProvider {
    private final Logger logger = LoggerFactory.getLogger(EventWrapperViewTable.class);
    public static final String SCROLLING_TO_BOTTOM_PROPERTY = "scrollingToBottom";
    public static final String FILTER_CONDITION_PROPERTY = "filterCondition";
    protected TooltipGenerator[] tooltipGenerators;
    private boolean scrollingToBottom;
    private Condition filterCondition;
    protected EventWrapperTableModelBase<T> tableModel;
    private static final Colors NOT_MATCHING_COLORS = new Colors(new Color(192, 192, 192), new Color(245, 245, 245), true);
    private static final Colors EVEN_ROW_COLORS = new Colors(new Color(0, 0, 0), new Color(255, 255, 255));
    private static final Colors ODD_ROW_COLORS = new Colors(new Color(0, 0, 0), new Color(233, 237, 242));

    public EventWrapperViewTable(EventWrapperTableModelBase<T> model) {
        this.tableModel = model;
        this.tableModel.addTableModelListener(new ScrollToBottomListener());
        this.setModel(this.tableModel);
        this.setSelectionMode(0);
        this.addFocusListener(new RepaintFocusListener());
        this.initColumnModel();
        this.initTooltipGenerators();
        this.setShowHorizontalLines(false);
        this.setAutoResizeMode(0);
    }

    protected abstract void initTooltipGenerators();

    protected abstract void initColumnModel();

    public Condition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(Condition filterCondition) {
        Condition oldValue = this.filterCondition;
        this.filterCondition = filterCondition;
        this.repaint();
        this.firePropertyChange(FILTER_CONDITION_PROPERTY, oldValue, filterCondition);
    }

    public void scrollToBottom() {
        int row = this.getRowCount();
        this.selectRow(--row);
    }

    public void selectRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting row {}.", (Object)row);
            }
            this.getSelectionModel().setSelectionInterval(0, row);
            this.scrollRectToVisible(this.getCellRect(row, 0, true));
        }
    }

    public boolean isScrollingToBottom() {
        return this.scrollingToBottom;
    }

    public void setScrollingToBottom(boolean scrollingToBottom) {
        if (this.scrollingToBottom != scrollingToBottom) {
            Boolean oldValue = this.scrollingToBottom;
            this.scrollingToBottom = scrollingToBottom;
            if (scrollingToBottom) {
                this.scrollToBottom();
            }
            this.firePropertyChange(SCROLLING_TO_BOTTOM_PROPERTY, oldValue, (Object)scrollingToBottom);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        InputMap inputMap;
        Object key;
        if (this.logger.isDebugEnabled()) {
            Object[] args = new Object[]{ks, e, condition, pressed};
            this.logger.debug("Processing KeyBinding:\n\tKeyStroke: {}\n\nEvent    : {}\n\tcondition: {}\n\tpressed  : {}\n", args);
        }
        if ((key = (inputMap = this.getInputMap(condition)).get(ks)) != null) {
            String keyStr = "" + key;
            if (keyStr.startsWith("select")) {
                if (this.isScrollingToBottom()) {
                    this.setScrollingToBottom(false);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("select detected! {}", (Object)keyStr);
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ActionKey: {}", (Object)keyStr);
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TooltipGenerator generator;
        Point p = event.getPoint();
        int row = this.rowAtPoint(p);
        int column = this.columnAtPoint(p);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ColumnIndex before conversion: {}", (Object)column);
        }
        column = this.convertColumnIndexToModel(column);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ColumnIndex after conversion: {}", (Object)column);
        }
        if (column >= 0 && column < this.tooltipGenerators.length && (generator = this.tooltipGenerators[column]) != null) {
            return generator.createTooltipText(this, row);
        }
        return null;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.logger.isDebugEnabled()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeSelection({}, {}, {}, {})", new Object[]{rowIndex, columnIndex, toggle, extend});
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("changeSelection-Stacktrace", new Throwable());
            }
        }
        if (this.isScrollingToBottom()) {
            this.setScrollingToBottom(false);
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
    }

    @Override
    public Colors resolveColors(EventWrapper object, int row, int column) {
        if (this.filterCondition != null && !this.filterCondition.isTrue((Object)object)) {
            return NOT_MATCHING_COLORS;
        }
        if (row % 2 == 0) {
            return EVEN_ROW_COLORS;
        }
        return ODD_ROW_COLORS;
    }

    private class RepaintFocusListener
    implements FocusListener {
        private RepaintFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            EventWrapperViewTable.this.repaint();
        }

        public void focusLost(FocusEvent e) {
            EventWrapperViewTable.this.repaint();
        }
    }

    private class ScrollToBottomListener
    implements TableModelListener {
        private ScrollToBottomListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (EventWrapperViewTable.this.scrollingToBottom) {
                EventWrapperViewTable.this.scrollToBottom();
            }
        }
    }
}

