/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.sulky.swing.GraphicsUtilities;
import de.huxhorn.sulky.swing.filters.ColorTintFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutPanel
extends JComponent {
    private final Logger logger = LoggerFactory.getLogger(AboutPanel.class);
    public static final String BACKGROUND_IMAGE_RESOURCE = "background.png";
    public static final String ABOUT_IMAGE_RESOURCE = "about.png";
    public static final String TEXT_RESOURCE_PREFIX = "about.";
    public static final String SCROLL_TEXT_RESOURCE = "about.scroll.text";
    public static final String VERSION_TEXT_RESOURCE = "about.version.text";
    public static final String VERSION_HEIGHT_RESOURCE = "about.version.height";
    public static final String SCROLL_AREA_RESOURCE_BASE = "about.scroll.area.";
    public static final String SCROLL_AREA_X_RESOURCE = "about.scroll.area.x";
    public static final String SCROLL_AREA_Y_RESOURCE = "about.scroll.area.y";
    public static final String SCROLL_AREA_WIDTH_RESOURCE = "about.scroll.area.width";
    public static final String SCROLL_AREA_HEIGHT_RESOURCE = "about.scroll.area.height";
    public static final String SCROLL_AREA_TOOLTIP_TEXT_RESOURCE = "about.scroll.area.tooltip.text";
    public static final String TEXT_RESOURCE_BUNDLE_RESOURCE = "TextResources";
    public static final int MOUSE_DISABLED = 0;
    public static final int MOUSE_COMPONENT = 1;
    public static final int MOUSE_SCROLLAREA = 2;
    public static final int MOUSE_BACKGROUND = 3;
    private static final int SCROLL_PIXELS = 1;
    private BufferedImage backgroundImage;
    private BufferedImage aboutImage;
    private FontMetrics fontMetrics;
    private Insets insets;
    private Dimension size;
    private Dimension preferredSize;
    private Point offscreenOffset;
    private String[] scrollLines;
    private String versionText;
    private String scrollAreaToolTipText;
    private int versionHeight;
    private int scrollPosition;
    private int maxScrollPosition;
    private int minScrollPosition;
    private Rectangle maxScrollArea;
    private Rectangle backgroundImageArea;
    private Rectangle translatedBackgroundImageArea;
    private Rectangle translatedScrollArea;
    private Rectangle scrollArea;
    private Rectangle paintArea;
    private BufferedImage offscreenImage;
    private BufferedImage scrollImage;
    private boolean scrolling;
    private int mouseEventHandling = 3;
    private boolean debug;
    private Timer timer;

    public AboutPanel(URL backgroundImageUrl, Rectangle scrollArea, String scrollText) throws IOException {
        this(backgroundImageUrl, scrollArea, scrollText, null, null, -1);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public AboutPanel(URL backgroundImageUrl, Rectangle scrollArea, String scrollText, String versionText, int versionHeight) throws IOException {
        this(backgroundImageUrl, scrollArea, scrollText, null, versionText, versionHeight);
    }

    public AboutPanel(URL backgroundImageUrl, Rectangle scrollArea, String scrollText, URL imageUrl, String versionText, int versionHeight) throws IOException {
        this();
        if (backgroundImageUrl == null) {
            throw new NullPointerException("backgroundImageUrl must not be null!");
        }
        if (scrollText == null) {
            throw new NullPointerException("scrollText must not be null!");
        }
        this.init(backgroundImageUrl, scrollArea, scrollText, imageUrl, versionText, versionHeight);
    }

    public AboutPanel() {
        TimerActionListener timerListener = new TimerActionListener();
        this.timer = new Timer(10, timerListener);
        this.initAttributes();
        this.addPropertyChangeListener(new AboutPropertyChangeListener());
        this.addComponentListener(new AboutComponentListener());
        this.setFont(null);
        AboutMouseInputListener mouseInputListener = new AboutMouseInputListener();
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
        this.setScrolling(false);
    }

    private void init(URL backgroundImageUrl, Rectangle scrollArea, String scrollText, URL imageUrl, String versionText, int versionHeight) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("init called with following arguments: backgroundImageUrl=" + backgroundImageUrl + ", " + "scrollArea=" + scrollArea + ", scrollText=" + scrollText + ", imageUrl=" + imageUrl + ", versionText=" + versionText + ", versionHeight=" + versionHeight);
        }
        this.setBackgroundImage(backgroundImageUrl);
        this.setScrollArea(scrollArea);
        this.setAboutImage(imageUrl);
        this.versionText = versionText;
        this.versionHeight = versionHeight;
        this.setScrollText(scrollText);
    }

    private void initAttributes() {
        this.preferredSize = new Dimension();
        this.offscreenOffset = new Point();
        this.backgroundImageArea = new Rectangle();
        this.translatedScrollArea = new Rectangle();
        this.translatedBackgroundImageArea = new Rectangle();
        this.scrollArea = new Rectangle();
        this.paintArea = new Rectangle();
        this.insets = this.getInsets();
    }

    public void setScrollText(String ScrollText) {
        StringTokenizer st = new StringTokenizer(ScrollText, "\n", true);
        ArrayList<String> lines = new ArrayList<String>(st.countTokens() / 2);
        String prevToken = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                if (prevToken != null && !prevToken.equals("\n")) {
                    lines.add(prevToken);
                } else {
                    lines.add("");
                }
            }
            prevToken = token;
        }
        if (prevToken != null && !prevToken.equals("\n")) {
            lines.add(prevToken);
        }
        String[] loScrollLines = new String[lines.size()];
        loScrollLines = lines.toArray(loScrollLines);
        this.setScrollLines(loScrollLines);
    }

    protected void setScrollLines(String[] scrollLines) {
        if (scrollLines == null) {
            NullPointerException ex = new NullPointerException("scrollLines must not be null!");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parameter 'scrollLines' of method 'setScrollLines' must not be null!", (Throwable)ex);
            }
            throw ex;
        }
        this.scrollLines = (String[])scrollLines.clone();
        this.flushScrollImage();
    }

    public void setBackgroundImage(URL imageUrl) throws IOException {
        this.setBackgroundImage(GraphicsUtilities.loadCompatibleImage((URL)imageUrl));
    }

    public void setBackgroundImage(BufferedImage BackgroundImage) {
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
            this.backgroundImage = null;
        }
        this.backgroundImage = BackgroundImage;
        this.updateBackgroundAttributes();
    }

    public void setAboutImage(URL imageUrl) throws IOException {
        this.setAboutImage(GraphicsUtilities.loadCompatibleImage((URL)imageUrl));
    }

    public void setAboutImage(BufferedImage AboutImage) {
        if (this.aboutImage != null) {
            this.aboutImage.flush();
            this.aboutImage = null;
        }
        this.aboutImage = AboutImage;
        this.flushScrollImage();
    }

    public void setScrollArea(Rectangle ScrollArea) {
        this.maxScrollArea = ScrollArea != null ? this.backgroundImageArea.intersection(ScrollArea) : (Rectangle)this.backgroundImageArea.clone();
        this.minScrollPosition = -this.maxScrollArea.height;
        this.calculateAttributes();
        this.flushScrollImage();
    }

    private void flushScrollImage() {
        if (this.scrollImage != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Flushing ScrollImage");
            }
            this.scrollImage.flush();
            this.scrollImage = null;
        }
        this.setScrollPosition(this.minScrollPosition);
    }

    private void flushOffscreenImage() {
        if (this.offscreenImage != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Flushing OffscreenImage");
            }
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    private void updateBackgroundAttributes() {
        this.backgroundImageArea.x = 0;
        this.backgroundImageArea.y = 0;
        this.backgroundImageArea.width = this.backgroundImage.getWidth();
        this.backgroundImageArea.height = this.backgroundImage.getHeight();
        this.calculatePreferredSize();
        this.maxScrollArea = this.maxScrollArea != null ? this.maxScrollArea.intersection(this.backgroundImageArea) : (Rectangle)this.backgroundImageArea.clone();
        this.flushOffscreenImage();
        this.flushScrollImage();
        this.repaint();
    }

    public void setScrollAreaToolTipText(String toolTipText) {
        this.scrollAreaToolTipText = toolTipText;
    }

    public String getScrollAreaToolTipText() {
        return this.scrollAreaToolTipText;
    }

    public String getToolTipText(MouseEvent evt) {
        if (this.handleMouseEvent(evt)) {
            return this.scrollAreaToolTipText;
        }
        return null;
    }

    protected boolean handleMouseEvent(MouseEvent evt) {
        Rectangle loArea = null;
        if (this.mouseEventHandling == 3) {
            loArea = this.translatedBackgroundImageArea;
        } else if (this.mouseEventHandling == 2) {
            loArea = this.translatedScrollArea;
        } else if (this.mouseEventHandling == 0) {
            return false;
        }
        Point loPoint = evt.getPoint();
        if (loArea == null) {
            return this.contains(loPoint);
        }
        return loArea.contains(loPoint);
    }

    protected void increaseScrollPosition() {
        this.setScrollPosition(this.scrollPosition + 1);
    }

    public void setScrollPosition(int scrollPosition) {
        if (scrollPosition > this.maxScrollPosition) {
            int remainder = scrollPosition % this.maxScrollPosition;
            scrollPosition = this.minScrollPosition + remainder;
        } else if (scrollPosition < this.minScrollPosition) {
            int remainder = scrollPosition % this.minScrollPosition;
            scrollPosition = this.maxScrollPosition + remainder;
        }
        if (this.scrollPosition != scrollPosition) {
            this.scrollPosition = scrollPosition;
            this.repaintScrollArea();
        }
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    public int getMinimumScrollPosition() {
        return this.minScrollPosition;
    }

    public int getMaximumScrollPosition() {
        return this.maxScrollPosition;
    }

    private void processOffscreenImage() {
        Graphics2D g;
        if (this.offscreenImage == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Creating offscreen-image");
            }
            boolean opaque = false;
            if (this.isOpaque()) {
                this.offscreenImage = GraphicsUtilities.createOpaqueCompatibleImage((int)this.backgroundImageArea.width, (int)this.backgroundImageArea.height);
                opaque = true;
            } else {
                this.offscreenImage = GraphicsUtilities.createTranslucentCompatibleImage((int)this.backgroundImageArea.width, (int)this.backgroundImageArea.height);
            }
            g = (Graphics2D)this.offscreenImage.getGraphics();
            if (opaque) {
                g.setColor(this.getBackground());
                g.fillRect(this.backgroundImageArea.x, this.backgroundImageArea.y, this.backgroundImageArea.width, this.backgroundImageArea.height);
            }
            g.drawImage((Image)this.backgroundImage, 0, 0, null);
            if (this.versionText != null) {
                g.setColor(this.getForeground());
                g.drawString(this.versionText, this.maxScrollArea.x + (this.maxScrollArea.width - this.fontMetrics.stringWidth(this.versionText)) / 2, this.versionHeight);
            }
        } else {
            g = (Graphics2D)this.offscreenImage.getGraphics();
        }
        g.setFont(this.getFont());
        this.drawScrollArea(g);
        g.dispose();
    }

    private void drawScrollArea(Graphics2D g) {
        this.initScrollImage();
        g.setClip(this.scrollArea.x, this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
        g.setColor(this.getBackground());
        g.fillRect(this.scrollArea.x, this.scrollArea.y, this.scrollArea.width, this.scrollArea.height);
        g.drawImage((Image)this.backgroundImage, 0, 0, this);
        if (this.versionText != null) {
            g.setColor(this.getForeground());
            g.drawString(this.versionText, this.maxScrollArea.x + (this.maxScrollArea.width - this.fontMetrics.stringWidth(this.versionText)) / 2, this.versionHeight);
        }
        g.drawImage((Image)this.scrollImage, this.scrollArea.x, this.scrollArea.y - this.scrollPosition, this);
        if (this.debug) {
            g.setColor(Color.YELLOW);
            g.drawRect(this.scrollArea.x, this.scrollArea.y, this.scrollArea.width - 1, this.scrollArea.height - 1);
        }
    }

    private void initScrollImage() {
        int fontHeight = this.fontMetrics.getHeight();
        this.maxScrollPosition = fontHeight * this.scrollLines.length;
        int additionalImageOffset = 0;
        int imageWidth = 0;
        if (this.aboutImage != null) {
            imageWidth = this.aboutImage.getWidth();
            additionalImageOffset = this.aboutImage.getHeight() + 2 * fontHeight;
            this.maxScrollPosition += additionalImageOffset;
        }
        if (this.scrollImage != null && this.scrollImage.getHeight() != this.maxScrollPosition) {
            this.flushScrollImage();
        }
        if (this.scrollImage == null) {
            int maxWidth = imageWidth + 2 * fontHeight;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("imageWidth={}, maxWidth={}", (Object)imageWidth, (Object)maxWidth);
            }
            for (String scrollLine : this.scrollLines) {
                int curWidth = this.fontMetrics.stringWidth(scrollLine);
                if (curWidth <= maxWidth) continue;
                maxWidth = curWidth;
            }
            if (maxWidth > this.maxScrollArea.width) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("maxWidth={} != maxScrollArea=", (Object)maxWidth, (Object)this.maxScrollArea);
                }
                maxWidth = this.maxScrollArea.width;
            }
            this.scrollArea.x = this.maxScrollArea.x + (this.maxScrollArea.width - maxWidth) / 2;
            this.scrollArea.y = this.maxScrollArea.y;
            this.scrollArea.width = maxWidth;
            this.scrollArea.height = this.maxScrollArea.height;
            this.scrollImage = GraphicsUtilities.createTranslucentCompatibleImage((int)this.scrollArea.width, (int)this.maxScrollPosition);
            Color foreground = this.getForeground();
            Graphics2D g = (Graphics2D)this.scrollImage.getGraphics();
            g.setFont(this.getFont());
            if (this.aboutImage != null) {
                g.drawImage((Image)this.aboutImage, (this.scrollArea.width - imageWidth) / 2, fontHeight, null);
            }
            g.setColor(foreground);
            int y = this.fontMetrics.getAscent() + additionalImageOffset;
            for (String line : this.scrollLines) {
                g.drawString(line, (this.scrollArea.width - this.fontMetrics.stringWidth(line)) / 2, y);
                y += fontHeight;
            }
            g.dispose();
            BufferedImage copy = GraphicsUtilities.createCompatibleCopy((BufferedImage)this.scrollImage);
            int blurSize = 10;
            ConvolveOp filter = AboutPanel.getGaussianBlurFilter(10, false);
            this.scrollImage = filter.filter(this.scrollImage, null);
            filter = AboutPanel.getGaussianBlurFilter(10, true);
            this.scrollImage = filter.filter(this.scrollImage, null);
            filter = new ColorTintFilter(Color.GREEN, 1.0f);
            this.scrollImage = filter.filter(this.scrollImage, null);
            g = (Graphics2D)this.scrollImage.getGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.drawImage((Image)copy, 0, 0, null);
            if (this.debug) {
                g.setColor(Color.RED);
                g.drawRect(0, 0, this.scrollImage.getWidth() - 1, this.scrollImage.getHeight() - 1);
                g.setColor(Color.GREEN);
                g.drawRect((this.scrollArea.width - imageWidth) / 2, fontHeight, this.aboutImage.getWidth(), this.aboutImage.getHeight());
            }
            g.dispose();
            copy.flush();
        }
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        int i;
        Logger logger = LoggerFactory.getLogger(AboutPanel.class);
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
        }
        for (i = 0; i < data.length; ++i) {
            int n = i;
            data[n] = data[n] / total;
            if (!logger.isDebugEnabled()) continue;
            logger.debug("data[{}]={}", (Object)i, (Object)Float.valueOf(data[i]));
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public void setFont(Font newFont) {
        if (newFont == null) {
            newFont = UIManager.getFont("Label.font");
        }
        if (newFont != null && !newFont.equals(this.getFont())) {
            super.setFont(newFont);
            this.fontMetrics = this.getFontMetrics(newFont);
            this.flushScrollImage();
        }
    }

    public void paintComponent(Graphics _g) {
        super.paintComponent(_g);
        this.processOffscreenImage();
        Graphics2D g = (Graphics2D)_g.create();
        g.setClip(this.paintArea.x, this.paintArea.y, this.paintArea.width, this.paintArea.height);
        g.drawImage((Image)this.offscreenImage, this.paintArea.x + this.offscreenOffset.x, this.paintArea.y + this.offscreenOffset.y, this);
        g.dispose();
    }

    private void calculateAttributes() {
        this.size = this.getSize(this.size);
        this.paintArea.x = this.insets.left;
        this.paintArea.y = this.insets.top;
        this.paintArea.width = this.size.width - this.insets.left - this.insets.right;
        this.paintArea.height = this.size.height - this.insets.top - this.insets.bottom;
        int loOffscreenOffsetX = (this.paintArea.width - this.preferredSize.width) / 2;
        int loOffscreenOffsetY = (this.paintArea.height - this.preferredSize.height) / 2;
        if (loOffscreenOffsetX < 0) {
            loOffscreenOffsetX = 0;
        }
        if (loOffscreenOffsetY < 0) {
            loOffscreenOffsetY = 0;
        }
        this.offscreenOffset.x = loOffscreenOffsetX;
        this.offscreenOffset.y = loOffscreenOffsetY;
        this.translatedScrollArea.x = this.maxScrollArea.x + this.offscreenOffset.x;
        this.translatedScrollArea.y = this.maxScrollArea.y + this.offscreenOffset.y;
        this.translatedScrollArea.width = this.maxScrollArea.width;
        this.translatedScrollArea.height = this.maxScrollArea.height;
        this.translatedBackgroundImageArea.x = this.backgroundImageArea.x + this.offscreenOffset.x;
        this.translatedBackgroundImageArea.y = this.backgroundImageArea.y + this.offscreenOffset.y;
        this.translatedBackgroundImageArea.width = this.backgroundImageArea.width;
        this.translatedBackgroundImageArea.height = this.backgroundImageArea.height;
        this.repaint();
    }

    protected void calculatePreferredSize() {
        this.insets = this.getInsets(this.insets);
        this.preferredSize.width = this.insets.left + this.insets.right + this.backgroundImageArea.width;
        this.preferredSize.height = this.insets.top + this.insets.bottom + this.backgroundImageArea.height;
        this.setPreferredSize(this.preferredSize);
        this.invalidate();
    }

    private void repaintScrollArea() {
        this.repaint(this.scrollArea.x + this.offscreenOffset.x, this.scrollArea.y + this.offscreenOffset.y, this.scrollArea.width, this.scrollArea.height);
    }

    public void addNotify() {
        super.addNotify();
        this.setScrolling(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.setScrolling(false);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.flushOffscreenImage();
        this.flushScrollImage();
    }

    public void setScrolling(boolean Scrolling) {
        if (this.scrolling != Scrolling) {
            this.scrolling = Scrolling;
            if (this.scrolling) {
                this.timer.start();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Timer started.");
                }
            } else {
                this.timer.stop();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Timer stopped.");
                }
            }
        }
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    private class TimerActionListener
    implements ActionListener {
        private final Logger logger = LoggerFactory.getLogger(AboutPanel.class);
        private long lastRepaintStart;
        private long frequency = 25L;

        private TimerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            long currentTime = System.nanoTime() / 1000000L;
            long meanTime = currentTime - this.lastRepaintStart;
            if (meanTime > this.frequency) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Tick! meanTime={}", (Object)meanTime);
                }
                AboutPanel.this.increaseScrollPosition();
                this.lastRepaintStart = currentTime;
            }
        }
    }

    class AboutMouseInputListener
    extends MouseInputAdapter {
        Point lastPoint = null;
        boolean scrollingBeforePress = false;
        boolean dragged = false;

        AboutMouseInputListener() {
        }

        public void mousePressed(MouseEvent evt) {
            if (AboutPanel.this.handleMouseEvent(evt)) {
                this.lastPoint = evt.getPoint();
                this.scrollingBeforePress = AboutPanel.this.isScrolling();
                AboutPanel.this.setScrolling(false);
            } else {
                this.lastPoint = null;
            }
            this.dragged = false;
        }

        public void mouseReleased(MouseEvent evt) {
            if (this.dragged) {
                this.lastPoint = null;
                AboutPanel.this.setScrolling(this.scrollingBeforePress);
            }
        }

        public void mouseClicked(MouseEvent evt) {
            if (AboutPanel.this.handleMouseEvent(evt)) {
                AboutPanel.this.setScrolling(!this.scrollingBeforePress);
            }
            this.dragged = false;
        }

        public void mouseDragged(MouseEvent evt) {
            if (this.lastPoint != null) {
                this.dragged = true;
                Point currentPoint = evt.getPoint();
                int yOffset = this.lastPoint.y - currentPoint.y;
                AboutPanel.this.setScrollPosition(AboutPanel.this.getScrollPosition() + yOffset);
                this.lastPoint = currentPoint;
            }
        }
    }

    class AboutPropertyChangeListener
    implements PropertyChangeListener {
        AboutPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("border")) {
                AboutPanel.this.calculatePreferredSize();
            } else if (propertyName.equals("foreground")) {
                AboutPanel.this.flushScrollImage();
            } else if (propertyName.equals("background")) {
                AboutPanel.this.flushScrollImage();
            }
        }
    }

    class AboutComponentListener
    extends ComponentAdapter {
        AboutComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            AboutPanel.this.calculateAttributes();
        }
    }
}

