/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.filters;

import de.huxhorn.sulky.conditions.Condition;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyFilter
implements Condition {
    private static final long serialVersionUID = 5218190112764981462L;
    private final Logger logger = LoggerFactory.getLogger(GroovyFilter.class);
    private String scriptFileName;
    private transient Object instance;
    private transient String scriptName;

    public GroovyFilter() {
        this(null);
    }

    public GroovyFilter(String scriptFileName) {
        this.setScriptFileName(scriptFileName);
    }

    public void setScriptFileName(String scriptFileName) {
        block4: {
            this.instance = null;
            this.scriptName = null;
            this.scriptFileName = scriptFileName;
            if (scriptFileName != null) {
                File scriptFile = new File(scriptFileName);
                if (!scriptFile.isFile() && this.logger.isWarnEnabled()) {
                    this.logger.warn("Scriptfile '{}' is not a file!", (Object)scriptFile.getAbsolutePath());
                }
                GroovyClassLoader gcl = new GroovyClassLoader();
                gcl.setShouldRecompile(Boolean.valueOf(true));
                try {
                    Class clazz = gcl.parseClass(scriptFile);
                    this.instance = clazz.newInstance();
                    this.scriptName = scriptFile.getName();
                }
                catch (Throwable e) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Exception while instanciating groovy condition '" + scriptFile.getAbsolutePath() + "'!", e);
                }
            }
        }
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public boolean isTrue(Object o) {
        try {
            if (this.instance instanceof Condition) {
                Condition condition = (Condition)this.instance;
                return condition.isTrue(o);
            }
            if (this.instance instanceof Script) {
                Script script = (Script)this.instance;
                Binding binding = new Binding();
                binding.setVariable("input", o);
                binding.setVariable("logger", (Object)this.logger);
                script.setBinding(binding);
                Object result = script.run();
                return result != null && !result.equals(Boolean.FALSE);
            }
            return false;
        }
        catch (Throwable t) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception while executing '" + this.scriptFileName + "'!", t);
            }
            return false;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setScriptFileName(this.scriptFileName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroovyFilter that = (GroovyFilter)o;
        return !(this.scriptFileName == null ? that.scriptFileName != null : !this.scriptFileName.equals(that.scriptFileName));
    }

    public int hashCode() {
        return this.scriptFileName != null ? this.scriptFileName.hashCode() : 0;
    }

    public String toString() {
        return "groovy(" + this.scriptName + ")";
    }

    public GroovyFilter clone() throws CloneNotSupportedException {
        GroovyFilter result = (GroovyFilter)super.clone();
        result.setScriptFileName(result.scriptFileName);
        return result;
    }
}

