/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.sulky.buffers.BlockingCircularBuffer;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LilithBuffer<T extends Serializable>
extends BlockingCircularBuffer<EventWrapper<T>> {
    private ApplicationPreferences applicationPreferences;

    public LilithBuffer(ApplicationPreferences applicationPreferences, int bufferSize, int congestionDelay) {
        super(bufferSize, congestionDelay);
        this.applicationPreferences = applicationPreferences;
    }

    public LilithBuffer(ApplicationPreferences applicationPreferences, int bufferSize) {
        super(bufferSize);
        this.applicationPreferences = applicationPreferences;
    }

    public void add(EventWrapper<T> element) {
        Serializable event = element.getEvent();
        if (event == null || this.applicationPreferences.getSourceFiltering() == ApplicationPreferences.SourceFiltering.NONE) {
            super.add(element);
        } else {
            SourceIdentifier si = element.getSourceIdentifier();
            if (si != null && this.applicationPreferences.isValidSource(si.getIdentifier())) {
                super.add(element);
            }
        }
    }

    public void addAll(List<EventWrapper<T>> elements) {
        for (EventWrapper<T> current : elements) {
            this.add(current);
        }
    }

    public void addAll(EventWrapper<T>[] elements) {
        for (EventWrapper<T> current : elements) {
            this.add(current);
        }
    }
}

