/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.logging;

import java.awt.AWTKeyStroke;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.Style;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingLogging {
    public static void logInputMaps(JComponent component) {
        Logger logger = LoggerFactory.getLogger(SwingLogging.class);
        if (logger.isDebugEnabled()) {
            int[] conditions = new int[]{2, 0, 1};
            String[] conditionStrings = new String[]{"WHEN_IN_FOCUSED_WINDOW", "WHEN_FOCUSED", "WHEN_ANCESTOR_OF_FOCUSED_COMPONENT"};
            StringBuffer msg = new StringBuffer();
            for (int i = 0; i < conditions.length; ++i) {
                InputMap inputMap = component.getInputMap(conditions[i]);
                msg.append("InputMap for '").append(conditionStrings[i]).append("':\n");
                while (true) {
                    KeyStroke[] keyStrokes;
                    if ((keyStrokes = inputMap.keys()) != null) {
                        for (KeyStroke ks : keyStrokes) {
                            msg.append("\tKeyStroke: ").append(ks).append("\n");
                            msg.append("\tActionMapKey: ").append(inputMap.get(ks)).append("\n\n");
                        }
                    }
                    msg.append("######################################\n");
                    inputMap = inputMap.getParent();
                    if (inputMap == null) break;
                    msg.append("Parent:\n");
                }
                msg.append("No parent.\n\n");
            }
            ActionMap actionMap = component.getActionMap();
            msg.append("ActionMap:\n");
            while (true) {
                Object[] keys;
                if ((keys = actionMap.keys()) != null) {
                    for (Object key : keys) {
                        msg.append("\tKey: ").append(key).append("\n");
                        msg.append("\tAction: ").append(actionMap.get(key)).append("\n\n");
                    }
                }
                msg.append("######################################\n");
                actionMap = actionMap.getParent();
                if (actionMap == null) break;
                msg.append("Parent:\n");
            }
            msg.append("No parent.\n\n");
            if (logger.isDebugEnabled()) {
                logger.debug(msg.toString());
            }
        }
    }

    public static void logStyles(HTMLEditorKit htmlEditorKit) {
        Logger logger = LoggerFactory.getLogger(SwingLogging.class);
        if (logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Primary:\n");
            StyleSheet styleSheet = htmlEditorKit.getStyleSheet();
            SwingLogging.appendStyles(styleSheet, msg);
            logger.debug(msg.toString());
        }
    }

    private static void appendStyles(StyleSheet styleSheet, StringBuffer msg) {
        Enumeration<?> styleNames = styleSheet.getStyleNames();
        while (styleNames.hasMoreElements()) {
            Object styleName = styleNames.nextElement();
            Style style = styleSheet.getStyle("" + styleName);
            msg.append("StyleName: ").append(styleName).append("\nStyle: ").append(style).append("\n\n");
        }
        StyleSheet[] styleSheets = styleSheet.getStyleSheets();
        if (styleSheets != null && styleSheets.length > 0) {
            for (int i = 0; i < styleSheets.length; ++i) {
                msg.append("Child #").append(i).append(":");
                StyleSheet ss = styleSheets[i];
                SwingLogging.appendStyles(ss, msg);
            }
        }
    }

    public static void logTraversal(JComponent component) {
        Logger logger = LoggerFactory.getLogger(SwingLogging.class);
        int[] ids = new int[]{0, 1, 2, 3};
        String[] names = new String[]{"FORWARD_TRAVERSAL_KEYS", "BACKWARD_TRAVERSAL_KEYS", "UP_CYCLE_TRAVERSAL_KEYS", "DOWN_CYCLE_TRAVERSAL_KEYS"};
        if (logger.isDebugEnabled()) {
            for (int i = 0; i < ids.length; ++i) {
                Set<AWTKeyStroke> keys = component.getFocusTraversalKeys(ids[i]);
                logger.debug("ID: {}\nKeys:{}", (Object)names[i], keys);
            }
        }
    }
}

