/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.formatting;

public class SimpleXml {
    public static String escape(String input) {
        String result = input;
        result = result.replace('\u0000', ' ');
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        return result;
    }

    public static String unescape(String input) {
        String result = input;
        result = result.replace("&quot;", "\"");
        result = result.replace("&gt;", ">");
        result = result.replace("&lt;", "<");
        result = result.replace("&amp;", "&");
        return result;
    }

    public static String replaceNonValidXMLCharacters(String in, char replacementChar) {
        StringBuffer out = null;
        if (!(replacementChar == '\t' || replacementChar == '\n' || replacementChar == '\r' || replacementChar >= ' ' && replacementChar <= '\ud7ff' || replacementChar >= '\ue000' && replacementChar <= '\ufffd' || replacementChar >= '\u10000' && replacementChar <= '\u10ffff')) {
            throw new IllegalArgumentException("Replacement character 0x" + Integer.toString(replacementChar, 16) + " is invalid itself!");
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') continue;
            if (out == null) {
                out = new StringBuffer(in);
            }
            out.setCharAt(i, replacementChar);
        }
        if (out != null) {
            return out.toString();
        }
        return in;
    }
}

