/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.formatting;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanReadable {
    private static final Unit[] BINARY_UNITS = new Unit[]{new Unit(0x1000000000000000L, "exbi", "Ei"), new Unit(0x4000000000000L, "pebi", "Pi"), new Unit(0x10000000000L, "tebi", "Ti"), new Unit(0x40000000L, "gibi", "Gi"), new Unit(0x100000L, "mebi", "Mi"), new Unit(1024L, "kibi", "Ki")};
    private static final Unit[] DECIMAL_UNITS = new Unit[]{new Unit(1000000000000000000L, "exa", "E"), new Unit(1000000000000000L, "peta", "P"), new Unit(1000000000000L, "tera", "T"), new Unit(1000000000L, "giga", "G"), new Unit(1000000L, "mega", "M"), new Unit(1000L, "kilo", "k")};

    public static String getHumanReadableSize(long size, boolean useBinaryUnits, boolean useSymbol) {
        if (useBinaryUnits) {
            return HumanReadable.internalGetHumanReadableSize(size, BINARY_UNITS, useSymbol);
        }
        return HumanReadable.internalGetHumanReadableSize(size, DECIMAL_UNITS, useSymbol);
    }

    private static String internalGetHumanReadableSize(long size, Unit[] units, boolean useSymbol) {
        Logger logger = LoggerFactory.getLogger(HumanReadable.class);
        Unit correctUnit = null;
        long fraction = 0L;
        for (Unit unit : units) {
            fraction = size / unit.getFactor();
            if (fraction <= 0L) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Correct unit: " + unit);
            }
            correctUnit = unit;
            break;
        }
        if (correctUnit == null) {
            return "" + size + " ";
        }
        StringBuffer result = new StringBuffer();
        result.append(fraction);
        long remainder = size % correctUnit.getFactor();
        result.append(".");
        remainder *= 100L;
        if ((remainder /= correctUnit.getFactor()) < 10L) {
            result.append("0");
        }
        result.append(remainder);
        result.append(" ");
        if (useSymbol) {
            result.append(correctUnit.getSymbol());
        } else {
            result.append(correctUnit.getName());
        }
        return result.toString();
    }

    static {
        Logger logger = LoggerFactory.getLogger(HumanReadable.class);
        if (logger.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Binary units:\n");
            for (Unit unit : BINARY_UNITS) {
                msg.append("\t").append(unit).append("\n");
            }
            msg.append("\nDecimal units:\n");
            for (Unit unit : DECIMAL_UNITS) {
                msg.append("\t").append(unit).append("\n");
            }
            logger.debug(msg.toString());
        }
    }

    static class Unit {
        private String name;
        private long factor;
        private String symbol;

        public Unit(long factor, String name, String symbol) {
            this.factor = factor;
            this.name = name;
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public long getFactor() {
            return this.factor;
        }

        public void setFactor(long factor) {
            this.factor = factor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Unit[");
            result.append("name=").append(this.name);
            result.append(", symbol=").append(this.symbol);
            result.append(", factor=").append(this.factor);
            result.append("]");
            return result.toString();
        }
    }
}

